/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.ral.updatable.label;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Optional;
import org.apache.shardingsphere.distsql.handler.engine.update.DistSQLUpdateExecutor;
import org.apache.shardingsphere.distsql.handler.required.DistSQLExecutorClusterModeRequired;
import org.apache.shardingsphere.distsql.statement.type.ral.updatable.UnlabelComputeNodeStatement;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstance;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.cluster.persist.facade.ClusterPersistServiceFacade;

@DistSQLExecutorClusterModeRequired
public final class UnlabelComputeNodeExecutor
implements DistSQLUpdateExecutor<UnlabelComputeNodeStatement> {
    public void executeUpdate(UnlabelComputeNodeStatement sqlStatement, ContextManager contextManager) {
        String instanceId = sqlStatement.getInstanceId();
        Optional computeNodeInstance = contextManager.getComputeNodeInstanceContext().getClusterInstanceRegistry().find(instanceId);
        if (computeNodeInstance.isPresent()) {
            ClusterPersistServiceFacade clusterPersistServiceFacade = (ClusterPersistServiceFacade)contextManager.getPersistServiceFacade().getModeFacade();
            LinkedHashSet labels = new LinkedHashSet(((ComputeNodeInstance)computeNodeInstance.get()).getLabels());
            if (sqlStatement.getLabels().isEmpty()) {
                clusterPersistServiceFacade.getComputeNodeService().persistLabels(instanceId, Collections.emptyList());
            } else {
                labels.removeAll(sqlStatement.getLabels());
                clusterPersistServiceFacade.getComputeNodeService().persistLabels(instanceId, new ArrayList(labels));
            }
        }
    }

    public Class<UnlabelComputeNodeStatement> getType() {
        return UnlabelComputeNodeStatement.class;
    }
}

