/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler;

import com.google.common.base.Strings;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.parser.rule.SQLParserRule;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dal.EmptyStatement;
import org.apache.shardingsphere.sql.parser.statement.core.util.SQLUtils;

public final class ProxySQLComQueryParser {
    public static SQLStatement parse(String sql, DatabaseType databaseType, ConnectionSession connectionSession) {
        DatabaseType parserDatabaseType = ProxySQLComQueryParser.getParserDatabaseType(databaseType, connectionSession);
        if (SQLUtils.trimComment((String)sql).isEmpty()) {
            return new EmptyStatement(parserDatabaseType);
        }
        SQLParserRule rule = (SQLParserRule)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getGlobalRuleMetaData().getSingleRule(SQLParserRule.class);
        return rule.getSQLParserEngine(parserDatabaseType).parse(sql, false);
    }

    private static DatabaseType getParserDatabaseType(DatabaseType defaultDatabaseType, ConnectionSession connectionSession) {
        String databaseName = connectionSession.getUsedDatabaseName();
        return Strings.isNullOrEmpty((String)databaseName) || !ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().containsDatabase(databaseName) ? defaultDatabaseType : ProxyContext.getInstance().getContextManager().getDatabase(databaseName).getProtocolType();
    }

    @Generated
    private ProxySQLComQueryParser() {
    }
}

