/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.connector.jdbc.executor.callback;

import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.exception.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.JDBCDriverType;
import org.apache.shardingsphere.infra.metadata.database.resource.ResourceMetaData;
import org.apache.shardingsphere.proxy.backend.connector.DatabaseProxyConnector;
import org.apache.shardingsphere.proxy.backend.connector.jdbc.executor.callback.ProxyJDBCExecutorCallback;
import org.apache.shardingsphere.proxy.backend.connector.jdbc.executor.callback.impl.ProxyPreparedStatementExecutorCallback;
import org.apache.shardingsphere.proxy.backend.connector.jdbc.executor.callback.impl.ProxyStatementExecutorCallback;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;

public final class ProxyJDBCExecutorCallbackFactory {
    public static ProxyJDBCExecutorCallback newInstance(JDBCDriverType type, DatabaseType protocolType, ResourceMetaData resourceMetaData, SQLStatement sqlStatement, DatabaseProxyConnector databaseProxyConnector, boolean isReturnGeneratedKeys, boolean isExceptionThrown, boolean isFetchMetaData) {
        if (JDBCDriverType.STATEMENT == type) {
            return new ProxyStatementExecutorCallback(protocolType, resourceMetaData, sqlStatement, databaseProxyConnector, isReturnGeneratedKeys, isExceptionThrown, isFetchMetaData);
        }
        if (JDBCDriverType.PREPARED_STATEMENT == type) {
            return new ProxyPreparedStatementExecutorCallback(protocolType, resourceMetaData, sqlStatement, databaseProxyConnector, isReturnGeneratedKeys, isExceptionThrown, isFetchMetaData);
        }
        throw new UnsupportedSQLOperationException(String.format("Unsupported driver type: `%s`", type));
    }

    @Generated
    private ProxyJDBCExecutorCallbackFactory() {
    }
}

