/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.connector.firebird.metadata.data.loader;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.metadata.data.loader.MetaDataLoaderConnection;
import org.apache.shardingsphere.database.connector.core.metadata.data.loader.MetaDataLoaderMaterial;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;

final class FirebirdNonFixedLengthColumnSizeLoader {
    private final MetaDataLoaderMaterial material;

    Map<String, Map<String, Integer>> load() throws SQLException {
        if (this.material.getActualTableNames().isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Map<String, Integer>> result = new HashMap<String, Map<String, Integer>>(this.material.getActualTableNames().size(), 1.0f);
        DatabaseTypeRegistry databaseTypeRegistry = new DatabaseTypeRegistry(this.material.getStorageType());
        try (MetaDataLoaderConnection connection = new MetaDataLoaderConnection(this.material.getStorageType(), this.material.getDataSource().getConnection());){
            for (String each : this.material.getActualTableNames()) {
                String formattedTableName = databaseTypeRegistry.formatIdentifierPattern(each);
                Map<String, Integer> columnSizes = this.loadTableColumnSizes(connection, formattedTableName);
                result.put(each, columnSizes);
            }
        }
        return result;
    }

    private Map<String, Integer> loadTableColumnSizes(MetaDataLoaderConnection connection, String formattedTableName) throws SQLException {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        this.loadColumnSizesFromMetaData(connection, formattedTableName, result);
        return result.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(result);
    }

    private void loadColumnSizesFromMetaData(MetaDataLoaderConnection connection, String formattedTableName, Map<String, Integer> result) throws SQLException {
        try (ResultSet resultSet = connection.getMetaData().getColumns(connection.getCatalog(), connection.getSchema(), formattedTableName, "%");){
            while (resultSet.next()) {
                String columnName;
                int dataType;
                if (!Objects.equals(formattedTableName, resultSet.getString("TABLE_NAME")) || !this.isNonFixedLengthType(dataType = resultSet.getInt("DATA_TYPE")) || null == (columnName = resultSet.getString("COLUMN_NAME"))) continue;
                int columnSize = resultSet.getInt("COLUMN_SIZE");
                if (resultSet.wasNull() || columnSize <= 0) continue;
                result.put(columnName.toUpperCase(Locale.ENGLISH), columnSize);
            }
        }
    }

    private boolean isNonFixedLengthType(int dataType) {
        switch (dataType) {
            case -16: 
            case -15: 
            case -9: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    @Generated
    public FirebirdNonFixedLengthColumnSizeLoader(MetaDataLoaderMaterial material) {
        this.material = material;
    }
}

