/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqltranslator.rule;

import java.util.List;
import java.util.Optional;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.rule.scope.GlobalRule;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.sqltranslator.config.SQLTranslatorRuleConfiguration;
import org.apache.shardingsphere.sqltranslator.context.SQLTranslatorContext;
import org.apache.shardingsphere.sqltranslator.exception.SQLTranslationException;
import org.apache.shardingsphere.sqltranslator.spi.SQLTranslator;

public final class SQLTranslatorRule
implements GlobalRule {
    private final SQLTranslatorRuleConfiguration configuration;
    private final SQLTranslator translator;
    private final boolean useOriginalSQLWhenTranslatingFailed;

    public SQLTranslatorRule(SQLTranslatorRuleConfiguration ruleConfig) {
        this.configuration = ruleConfig;
        this.translator = TypedSPILoader.findService(SQLTranslator.class, (Object)ruleConfig.getType(), (Properties)ruleConfig.getProps()).orElse(null);
        this.useOriginalSQLWhenTranslatingFailed = ruleConfig.isUseOriginalSQLWhenTranslatingFailed();
    }

    public Optional<SQLTranslatorContext> translate(String sql, List<Object> parameters, QueryContext queryContext, DatabaseType storageType, ShardingSphereDatabase database, RuleMetaData globalRuleMetaData) {
        if (null == this.translator) {
            return Optional.empty();
        }
        DatabaseType sqlParserType = queryContext.getSqlStatementContext().getSqlStatement().getDatabaseType();
        if (sqlParserType.equals(storageType) || null == storageType) {
            return Optional.empty();
        }
        try {
            return Optional.of(this.translator.translate(sql, parameters, queryContext, storageType, database, globalRuleMetaData));
        }
        catch (SQLTranslationException ex) {
            if (this.useOriginalSQLWhenTranslatingFailed) {
                return Optional.empty();
            }
            throw ex;
        }
    }

    public int getOrder() {
        return 900;
    }

    @Generated
    public SQLTranslatorRuleConfiguration getConfiguration() {
        return this.configuration;
    }
}

