/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.database.metadata;

import org.apache.shardingsphere.mode.event.DataChangedEvent;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.database.DatabaseNodeValueChangedHandler;
import org.apache.shardingsphere.mode.manager.cluster.statistics.StatisticsRefreshEngine;
import org.apache.shardingsphere.mode.node.path.NodePath;
import org.apache.shardingsphere.mode.node.path.engine.searcher.NodePathSearchCriteria;
import org.apache.shardingsphere.mode.node.path.engine.searcher.NodePathSearcher;
import org.apache.shardingsphere.mode.node.path.type.database.metadata.schema.SchemaMetaDataNodePath;

public final class SchemaChangedHandler
implements DatabaseNodeValueChangedHandler {
    private final ContextManager contextManager;
    private final StatisticsRefreshEngine statisticsRefreshEngine;

    public SchemaChangedHandler(ContextManager contextManager) {
        this.contextManager = contextManager;
        this.statisticsRefreshEngine = new StatisticsRefreshEngine(contextManager);
    }

    @Override
    public NodePath getSubscribedNodePath(String databaseName) {
        return new SchemaMetaDataNodePath(databaseName, "([\\w-]+)");
    }

    @Override
    public void handle(String databaseName, DataChangedEvent event) {
        String schemaName = NodePathSearcher.get((String)event.getKey(), (NodePathSearchCriteria)SchemaMetaDataNodePath.createSchemaSearchCriteria((String)databaseName, (boolean)false));
        switch (event.getType()) {
            case ADDED: 
            case UPDATED: {
                this.handleCreated(databaseName, schemaName);
                break;
            }
            case DELETED: {
                this.handleDropped(databaseName, schemaName);
                break;
            }
        }
    }

    private void handleCreated(String databaseName, String schemaName) {
        this.contextManager.getMetaDataContextManager().getDatabaseMetaDataManager().addSchema(databaseName, schemaName);
        this.statisticsRefreshEngine.asyncRefresh();
    }

    private void handleDropped(String databaseName, String schemaName) {
        this.contextManager.getMetaDataContextManager().getDatabaseMetaDataManager().dropSchema(databaseName, schemaName);
        this.statisticsRefreshEngine.asyncRefresh();
    }
}

