/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.scenario.consistencycheck.task;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.PipelineDataConsistencyChecker;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.result.TableDataConsistencyCheckResult;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineContextKey;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineJobItemContext;
import org.apache.shardingsphere.data.pipeline.core.context.TransmissionProcessContext;
import org.apache.shardingsphere.data.pipeline.core.execute.AbstractPipelineLifecycleRunnable;
import org.apache.shardingsphere.data.pipeline.core.execute.ExecuteCallback;
import org.apache.shardingsphere.data.pipeline.core.execute.PipelineExecuteEngine;
import org.apache.shardingsphere.data.pipeline.core.execute.PipelineLifecycleRunnable;
import org.apache.shardingsphere.data.pipeline.core.job.JobStatus;
import org.apache.shardingsphere.data.pipeline.core.job.api.PipelineAPIFactory;
import org.apache.shardingsphere.data.pipeline.core.job.config.PipelineJobConfiguration;
import org.apache.shardingsphere.data.pipeline.core.job.id.PipelineJobIdUtils;
import org.apache.shardingsphere.data.pipeline.core.job.progress.TransmissionJobItemProgress;
import org.apache.shardingsphere.data.pipeline.core.job.progress.config.PipelineProcessConfiguration;
import org.apache.shardingsphere.data.pipeline.core.job.progress.config.PipelineProcessConfigurationUtils;
import org.apache.shardingsphere.data.pipeline.core.job.service.PipelineJobConfigurationManager;
import org.apache.shardingsphere.data.pipeline.core.job.service.PipelineJobItemManager;
import org.apache.shardingsphere.data.pipeline.core.job.service.PipelineJobManager;
import org.apache.shardingsphere.data.pipeline.core.job.type.PipelineJobType;
import org.apache.shardingsphere.data.pipeline.core.metadata.PipelineProcessConfigurationPersistService;
import org.apache.shardingsphere.data.pipeline.core.task.runner.PipelineTasksRunner;
import org.apache.shardingsphere.data.pipeline.scenario.consistencycheck.ConsistencyCheckJobType;
import org.apache.shardingsphere.data.pipeline.scenario.consistencycheck.config.ConsistencyCheckJobConfiguration;
import org.apache.shardingsphere.data.pipeline.scenario.consistencycheck.context.ConsistencyCheckJobItemContext;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConsistencyCheckTasksRunner
implements PipelineTasksRunner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConsistencyCheckTasksRunner.class);
    private final ConsistencyCheckJobType jobType = new ConsistencyCheckJobType();
    private final PipelineJobManager jobManager = new PipelineJobManager((PipelineJobType)this.jobType);
    private final PipelineJobItemManager<TransmissionJobItemProgress> jobItemManager = new PipelineJobItemManager(this.jobType.getOption().getYamlJobItemProgressSwapper());
    private final PipelineProcessConfigurationPersistService processConfigPersistService = new PipelineProcessConfigurationPersistService();
    private final ConsistencyCheckJobItemContext jobItemContext;
    private final ConsistencyCheckJobConfiguration checkJobConfig;
    private final String checkJobId;
    private final String parentJobId;
    private final PipelineLifecycleRunnable checkExecutor;
    private final AtomicReference<PipelineDataConsistencyChecker> consistencyChecker = new AtomicReference();

    public ConsistencyCheckTasksRunner(ConsistencyCheckJobItemContext jobItemContext) {
        this.jobItemContext = jobItemContext;
        this.checkJobConfig = jobItemContext.getJobConfig();
        this.checkJobId = this.checkJobConfig.getJobId();
        this.parentJobId = this.checkJobConfig.getParentJobId();
        this.checkExecutor = new CheckPipelineLifecycleRunnable();
    }

    public void start() {
        if (this.jobItemContext.isStopping()) {
            return;
        }
        new PipelineJobItemManager(((PipelineJobType)TypedSPILoader.getService(PipelineJobType.class, (Object)PipelineJobIdUtils.parseJobType((String)this.jobItemContext.getJobId()).getType())).getOption().getYamlJobItemProgressSwapper()).persistProgress((PipelineJobItemContext)this.jobItemContext);
        CompletableFuture future = this.jobItemContext.getProcessContext().getConsistencyCheckExecuteEngine().submit(this.checkExecutor);
        PipelineExecuteEngine.trigger(Collections.singletonList(future), (ExecuteCallback)new CheckExecuteCallback());
    }

    public void stop() {
        this.jobItemContext.setStopping(true);
        this.checkExecutor.stop();
    }

    @Generated
    public ConsistencyCheckJobItemContext getJobItemContext() {
        return this.jobItemContext;
    }

    private class CheckPipelineLifecycleRunnable
    extends AbstractPipelineLifecycleRunnable {
        private CheckPipelineLifecycleRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void runBlocking() {
            ConsistencyCheckTasksRunner.this.jobItemManager.persistProgress((PipelineJobItemContext)ConsistencyCheckTasksRunner.this.jobItemContext);
            PipelineJobType jobType = PipelineJobIdUtils.parseJobType((String)ConsistencyCheckTasksRunner.this.parentJobId);
            PipelineJobConfiguration parentJobConfig = new PipelineJobConfigurationManager(jobType.getOption()).getJobConfiguration(ConsistencyCheckTasksRunner.this.parentJobId);
            try {
                PipelineProcessConfiguration processConfig = PipelineProcessConfigurationUtils.fillInDefaultValue((PipelineProcessConfiguration)ConsistencyCheckTasksRunner.this.processConfigPersistService.load(PipelineJobIdUtils.parseContextKey((String)parentJobConfig.getJobId()), jobType.getType()));
                PipelineDataConsistencyChecker checker = jobType.buildDataConsistencyChecker(parentJobConfig, new TransmissionProcessContext(parentJobConfig.getJobId(), processConfig), ConsistencyCheckTasksRunner.this.jobItemContext.getProgressContext());
                ConsistencyCheckTasksRunner.this.consistencyChecker.set(checker);
                Map checkResultMap = checker.check(ConsistencyCheckTasksRunner.this.checkJobConfig.getAlgorithmTypeName(), ConsistencyCheckTasksRunner.this.checkJobConfig.getAlgorithmProps());
                log.info("job {} with check algorithm '{}' data consistency checker result: {}, stopping: {}", new Object[]{ConsistencyCheckTasksRunner.this.parentJobId, ConsistencyCheckTasksRunner.this.checkJobConfig.getAlgorithmTypeName(), checkResultMap, ConsistencyCheckTasksRunner.this.jobItemContext.isStopping()});
                if (!ConsistencyCheckTasksRunner.this.jobItemContext.isStopping()) {
                    PipelineAPIFactory.getPipelineGovernanceFacade((PipelineContextKey)PipelineJobIdUtils.parseContextKey((String)ConsistencyCheckTasksRunner.this.parentJobId)).getJobFacade().getCheck().persistCheckJobResult(ConsistencyCheckTasksRunner.this.parentJobId, ConsistencyCheckTasksRunner.this.checkJobId, checkResultMap);
                }
            }
            finally {
                ConsistencyCheckTasksRunner.this.jobItemContext.getProgressContext().setCheckEndTimeMillis(Long.valueOf(System.currentTimeMillis()));
            }
        }

        protected void doStop() {
            PipelineDataConsistencyChecker checker = (PipelineDataConsistencyChecker)ConsistencyCheckTasksRunner.this.consistencyChecker.get();
            if (null != checker) {
                checker.cancel();
            }
        }
    }

    private class CheckExecuteCallback
    implements ExecuteCallback {
        private CheckExecuteCallback() {
        }

        public void onSuccess() {
            if (ConsistencyCheckTasksRunner.this.jobItemContext.isStopping()) {
                log.info("onSuccess, stopping true, ignore");
                return;
            }
            log.info("onSuccess, check job id: {}, parent job id: {}", (Object)ConsistencyCheckTasksRunner.this.checkJobId, (Object)ConsistencyCheckTasksRunner.this.parentJobId);
            Map checkJobResult = PipelineAPIFactory.getPipelineGovernanceFacade((PipelineContextKey)PipelineJobIdUtils.parseContextKey((String)ConsistencyCheckTasksRunner.this.parentJobId)).getJobFacade().getCheck().getCheckJobResult(ConsistencyCheckTasksRunner.this.parentJobId, ConsistencyCheckTasksRunner.this.checkJobId);
            if (!checkJobResult.isEmpty() && checkJobResult.values().stream().allMatch(TableDataConsistencyCheckResult::isSuccessful)) {
                ConsistencyCheckTasksRunner.this.jobItemContext.setStatus(JobStatus.FINISHED);
            } else {
                ConsistencyCheckTasksRunner.this.jobItemContext.setStatus(JobStatus.CONSISTENCY_CHECK_FAILURE);
            }
            ConsistencyCheckTasksRunner.this.jobItemManager.persistProgress((PipelineJobItemContext)ConsistencyCheckTasksRunner.this.jobItemContext);
            ConsistencyCheckTasksRunner.this.jobManager.stop(ConsistencyCheckTasksRunner.this.checkJobId);
        }

        public void onFailure(Throwable throwable) {
            PipelineDataConsistencyChecker checker = (PipelineDataConsistencyChecker)ConsistencyCheckTasksRunner.this.consistencyChecker.get();
            if (null != checker && checker.isCanceling()) {
                log.info("onFailure, canceling, check job id: {}, parent job id: {}", (Object)ConsistencyCheckTasksRunner.this.checkJobId, (Object)ConsistencyCheckTasksRunner.this.parentJobId);
                ConsistencyCheckTasksRunner.this.jobManager.stop(ConsistencyCheckTasksRunner.this.checkJobId);
                return;
            }
            log.info("onFailure, check job id: {}, parent job id: {}", new Object[]{ConsistencyCheckTasksRunner.this.checkJobId, ConsistencyCheckTasksRunner.this.parentJobId, throwable});
            PipelineAPIFactory.getPipelineGovernanceFacade((PipelineContextKey)PipelineJobIdUtils.parseContextKey((String)ConsistencyCheckTasksRunner.this.checkJobId)).getJobItemFacade().getErrorMessage().update(ConsistencyCheckTasksRunner.this.checkJobId, 0, throwable);
            ConsistencyCheckTasksRunner.this.jobManager.stop(ConsistencyCheckTasksRunner.this.checkJobId);
        }
    }
}

