/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.util.yaml.constructor;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.infra.util.yaml.constructor.ShardingSphereYamlConstruct;
import org.apache.shardingsphere.infra.util.yaml.shortcuts.ShardingSphereYamlShortcuts;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.constructor.Construct;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;

public final class ShardingSphereYamlConstructor
extends Constructor {
    private final Class<?> rootClass;

    public ShardingSphereYamlConstructor(Class<?> rootClass) {
        super(rootClass, ShardingSphereYamlConstructor.createLoaderOptions());
        HashMap<String, Class> yamlShortcuts = new HashMap<String, Class>();
        ShardingSphereServiceLoader.getServiceInstances(ShardingSphereYamlShortcuts.class).stream().map(ShardingSphereYamlShortcuts::getYamlShortcuts).forEach(yamlShortcuts::putAll);
        yamlShortcuts.forEach((key, value) -> this.addTypeDescription(new TypeDescription(value, key)));
        this.rootClass = rootClass;
    }

    public static LoaderOptions createLoaderOptions() {
        LoaderOptions result = new LoaderOptions();
        result.setMaxAliasesForCollections(1000);
        result.setCodePointLimit(Integer.MAX_VALUE);
        return result;
    }

    protected Construct getConstructor(Node node) {
        Optional construct = TypedSPILoader.findService(ShardingSphereYamlConstruct.class, (Object)node.getType());
        return construct.isPresent() ? (Construct)construct.get() : super.getConstructor(node);
    }

    public Object constructObject(Node node) {
        Object result = super.constructObject(node);
        if (ShardingSphereYamlConstructor.isMappingNode(node, result)) {
            this.getPropertyUtils().getProperties(result.getClass()).stream().filter(Property::isWritable).forEach(each -> this.setEmptyCollectionIfNull(result, (Property)each));
        }
        return result;
    }

    private static boolean isMappingNode(Node node, Object target) {
        return null != target && node instanceof MappingNode && !(target instanceof Map) && !(target instanceof Collection);
    }

    private void setEmptyCollectionIfNull(Object target, Property property) {
        if (null == property.get(target)) {
            property.set(target, this.getEmptyCollection(property.getType()));
        }
    }

    private Object getEmptyCollection(Class<?> propertyType) {
        if (Properties.class.isAssignableFrom(propertyType)) {
            return new Properties();
        }
        if (Map.class.isAssignableFrom(propertyType)) {
            return Collections.emptyMap();
        }
        if (Set.class.isAssignableFrom(propertyType)) {
            return Collections.emptySet();
        }
        if (List.class.isAssignableFrom(propertyType)) {
            return Collections.emptyList();
        }
        if (Collection.class.isAssignableFrom(propertyType)) {
            return Collections.emptyList();
        }
        return null;
    }

    protected Class<?> getClassForName(String className) throws ClassNotFoundException {
        Preconditions.checkArgument((boolean)className.equals(this.rootClass.getName()), (String)"Class `%s` is not accepted", (Object)className);
        return super.getClassForName(className);
    }
}

