/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.opengauss.handler.admin.executor;

import com.cedarsoftware.util.CaseInsensitiveSet;
import java.util.Collection;
import java.util.Collections;
import lombok.Generated;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.metadata.RawQueryResultColumnMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.metadata.RawQueryResultMetaData;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataMergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminQueryExecutor;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;

public final class OpenGaussSelectPasswordDeadlineExecutor
implements DatabaseAdminQueryExecutor {
    private static final int DEFAULT_PASSWORD_DEADLINE = 90;
    private static final Collection<String> FUNCTION_NAMES = new CaseInsensitiveSet();
    private static final String INTERVAL_TO_NUM_PASSWORD_DEADLINE = "pg_catalog.intervaltonum(pg_catalog.gs_password_deadline())";
    private static final String PG_CATALOG_PASSWORD_DEADLINE = "pg_catalog.gs_password_deadline()";
    private static final String PASSWORD_DEADLINE = "gs_password_deadline()";
    private final String functionName;
    private MergedResult mergedResult;

    public void execute(ConnectionSession connectionSession, ShardingSphereMetaData metaData) {
        this.mergedResult = new LocalDataMergedResult(Collections.singleton(new LocalDataQueryResultRow(new Object[]{90})));
    }

    public QueryResultMetaData getQueryResultMetaData() {
        String columnName = INTERVAL_TO_NUM_PASSWORD_DEADLINE.equals(this.functionName) ? "intervaltonum" : "gs_password_deadline";
        return new RawQueryResultMetaData(Collections.singletonList(new RawQueryResultColumnMetaData("", columnName, columnName, 12, "VARCHAR", 100, 0)));
    }

    public static boolean accept(String functionName) {
        return FUNCTION_NAMES.contains(functionName);
    }

    @Generated
    public OpenGaussSelectPasswordDeadlineExecutor(String functionName) {
        this.functionName = functionName;
    }

    @Generated
    public MergedResult getMergedResult() {
        return this.mergedResult;
    }

    static {
        FUNCTION_NAMES.add(INTERVAL_TO_NUM_PASSWORD_DEADLINE);
        FUNCTION_NAMES.add(PG_CATALOG_PASSWORD_DEADLINE);
        FUNCTION_NAMES.add(PASSWORD_DEADLINE);
    }
}

