/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.firebird.packet.command.query.statement.prepare;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.FirebirdCommandPacket;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.info.type.sql.FirebirdSQLInfoPacketType;
import org.apache.shardingsphere.database.protocol.firebird.payload.FirebirdPacketPayload;
import org.apache.shardingsphere.database.protocol.packet.sql.SQLReceivedPacket;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.hint.SQLHintUtils;

public final class FirebirdPrepareStatementPacket
extends FirebirdCommandPacket
implements SQLReceivedPacket {
    private final int transactionId;
    private final int statementId;
    private final int sqlDialect;
    private final HintValueContext hintValueContext;
    private final String sql;
    private final List<FirebirdSQLInfoPacketType> infoItems = new ArrayList<FirebirdSQLInfoPacketType>();
    private int currentItemIdx = -1;
    private final int maxLength;

    public FirebirdPrepareStatementPacket(FirebirdPacketPayload payload) {
        payload.skipReserved(4);
        this.transactionId = payload.readInt4();
        this.statementId = payload.readInt4();
        this.sqlDialect = payload.readInt4();
        String originSQL = payload.readString();
        this.hintValueContext = SQLHintUtils.extractHint((String)originSQL);
        this.sql = SQLHintUtils.removeHint((String)originSQL);
        this.parseInfo(payload.readBuffer());
        this.maxLength = payload.readInt4();
    }

    private void parseInfo(ByteBuf buffer) {
        while (buffer.isReadable()) {
            this.infoItems.add(FirebirdSQLInfoPacketType.valueOf(buffer.readByte()));
        }
    }

    public boolean isValidStatementHandle() {
        return this.statementId != 65535;
    }

    public boolean nextItem() {
        ++this.currentItemIdx;
        return this.currentItemIdx < this.infoItems.size();
    }

    public FirebirdSQLInfoPacketType getCurrentItem() {
        return this.infoItems.get(this.currentItemIdx);
    }

    public String getSQL() {
        return this.sql;
    }

    @Override
    protected void write(FirebirdPacketPayload payload) {
    }

    public static int getLength(FirebirdPacketPayload payload) {
        int length = 16;
        length += payload.getBufferLength(length);
        length += payload.getBufferLength(length);
        return length + 4;
    }

    @Generated
    public int getTransactionId() {
        return this.transactionId;
    }

    @Generated
    public int getStatementId() {
        return this.statementId;
    }

    @Generated
    public int getSqlDialect() {
        return this.sqlDialect;
    }

    @Generated
    public HintValueContext getHintValueContext() {
        return this.hintValueContext;
    }

    @Generated
    public List<FirebirdSQLInfoPacketType> getInfoItems() {
        return this.infoItems;
    }

    @Generated
    public int getCurrentItemIdx() {
        return this.currentItemIdx;
    }

    @Generated
    public int getMaxLength() {
        return this.maxLength;
    }
}

