/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.firebird.packet.command;

import lombok.Generated;
import org.apache.shardingsphere.database.protocol.firebird.constant.protocol.FirebirdProtocolVersion;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.FirebirdCommandPacket;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.FirebirdCommandPacketType;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.admin.FirebirdUnsupportedCommandPacket;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.blob.FirebirdCancelBlobCommandPacket;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.blob.FirebirdCloseBlobCommandPacket;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.blob.FirebirdCreateBlobCommandPacket;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.blob.FirebirdGetBlobSegmentCommandPacket;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.blob.FirebirdOpenBlobCommandPacket;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.blob.FirebirdPutBlobSegmentCommandPacket;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.blob.FirebirdSeekBlobCommandPacket;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.info.FirebirdInfoPacket;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.info.type.blob.FirebirdBlobInfoPacketType;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.info.type.database.FirebirdDatabaseInfoPacketType;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.info.type.sql.FirebirdSQLInfoPacketType;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.statement.FirebirdAllocateStatementPacket;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.statement.FirebirdFetchStatementPacket;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.statement.FirebirdFreeStatementPacket;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.statement.execute.FirebirdExecuteStatementPacket;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.statement.prepare.FirebirdPrepareStatementPacket;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.transaction.FirebirdCommitTransactionPacket;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.transaction.FirebirdRollbackTransactionPacket;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.transaction.FirebirdStartTransactionPacket;
import org.apache.shardingsphere.database.protocol.firebird.payload.FirebirdPacketPayload;

public final class FirebirdCommandPacketFactory {
    public static FirebirdCommandPacket newInstance(FirebirdCommandPacketType commandPacketType, FirebirdPacketPayload payload, FirebirdProtocolVersion protocolVersion) {
        switch (commandPacketType) {
            case INFO_DATABASE: {
                return FirebirdDatabaseInfoPacketType.createPacket(payload);
            }
            case INFO_BLOB: {
                return FirebirdBlobInfoPacketType.createPacket(payload);
            }
            case TRANSACTION: {
                return new FirebirdStartTransactionPacket(payload);
            }
            case CREATE_BLOB: 
            case CREATE_BLOB2: {
                return new FirebirdCreateBlobCommandPacket(commandPacketType, payload);
            }
            case OPEN_BLOB: 
            case OPEN_BLOB2: {
                return new FirebirdOpenBlobCommandPacket(commandPacketType, payload);
            }
            case GET_SEGMENT: {
                return new FirebirdGetBlobSegmentCommandPacket(payload);
            }
            case PUT_SEGMENT: {
                return new FirebirdPutBlobSegmentCommandPacket(payload);
            }
            case CANCEL_BLOB: {
                return new FirebirdCancelBlobCommandPacket(payload);
            }
            case CLOSE_BLOB: {
                return new FirebirdCloseBlobCommandPacket(payload);
            }
            case SEEK_BLOB: {
                return new FirebirdSeekBlobCommandPacket(payload);
            }
            case ALLOCATE_STATEMENT: {
                return new FirebirdAllocateStatementPacket(payload);
            }
            case PREPARE_STATEMENT: {
                return new FirebirdPrepareStatementPacket(payload);
            }
            case EXECUTE: 
            case EXECUTE2: {
                return new FirebirdExecuteStatementPacket(payload, protocolVersion);
            }
            case FETCH: {
                return new FirebirdFetchStatementPacket(payload);
            }
            case INFO_SQL: {
                return FirebirdSQLInfoPacketType.createPacket(payload);
            }
            case COMMIT: {
                return new FirebirdCommitTransactionPacket(payload);
            }
            case ROLLBACK: {
                return new FirebirdRollbackTransactionPacket(payload);
            }
            case FREE_STATEMENT: {
                return new FirebirdFreeStatementPacket(payload);
            }
        }
        return new FirebirdUnsupportedCommandPacket(commandPacketType);
    }

    public static int getExpectedLength(FirebirdCommandPacketType commandPacketType, FirebirdPacketPayload payload, FirebirdProtocolVersion protocolVersion) {
        return FirebirdCommandPacketFactory.getLength(commandPacketType, payload, protocolVersion);
    }

    private static int getLength(FirebirdCommandPacketType commandPacketType, FirebirdPacketPayload payload, FirebirdProtocolVersion protocolVersion) throws IndexOutOfBoundsException {
        switch (commandPacketType) {
            case INFO_DATABASE: 
            case INFO_BLOB: 
            case INFO_SQL: {
                return FirebirdInfoPacket.getLength(payload);
            }
            case TRANSACTION: {
                return FirebirdStartTransactionPacket.getLength(payload);
            }
            case CREATE_BLOB: 
            case CREATE_BLOB2: {
                return FirebirdCreateBlobCommandPacket.getLength(commandPacketType, payload);
            }
            case OPEN_BLOB: 
            case OPEN_BLOB2: {
                return FirebirdOpenBlobCommandPacket.getLength(commandPacketType, payload);
            }
            case GET_SEGMENT: {
                return FirebirdGetBlobSegmentCommandPacket.getLength(payload);
            }
            case PUT_SEGMENT: {
                return FirebirdPutBlobSegmentCommandPacket.getLength(payload);
            }
            case CANCEL_BLOB: {
                return FirebirdCancelBlobCommandPacket.getLength();
            }
            case CLOSE_BLOB: {
                return FirebirdCloseBlobCommandPacket.getLength();
            }
            case SEEK_BLOB: {
                return FirebirdSeekBlobCommandPacket.getLength();
            }
            case ALLOCATE_STATEMENT: {
                return FirebirdAllocateStatementPacket.getLength();
            }
            case PREPARE_STATEMENT: {
                return FirebirdPrepareStatementPacket.getLength(payload);
            }
            case EXECUTE: 
            case EXECUTE2: {
                return FirebirdExecuteStatementPacket.getLength(payload, protocolVersion);
            }
            case FETCH: {
                return FirebirdFetchStatementPacket.getLength(payload);
            }
            case COMMIT: {
                return FirebirdCommitTransactionPacket.getLength();
            }
            case ROLLBACK: {
                return FirebirdRollbackTransactionPacket.getLength();
            }
            case FREE_STATEMENT: {
                return FirebirdFreeStatementPacket.getLength();
            }
        }
        return 0;
    }

    @Generated
    private FirebirdCommandPacketFactory() {
    }
}

