/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.firebird.constant.buffer;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.firebird.constant.buffer.FirebirdParameterBufferType;
import org.apache.shardingsphere.database.protocol.firebird.exception.FirebirdProtocolException;

public final class FirebirdParameterBuffer {
    private int version;
    private final Map<FirebirdParameterBufferType, Object> parameterBuffer = new HashMap<FirebirdParameterBufferType, Object>();
    private final Function<Integer, FirebirdParameterBufferType> valueOf;
    private final Function<Integer, Boolean> isTraditionalType;

    public void parseBuffer(ByteBuf buffer) {
        this.version = buffer.readUnsignedByte();
        while (buffer.isReadable()) {
            FirebirdParameterBufferType type = this.valueOf.apply(Integer.valueOf(buffer.readUnsignedByte()));
            this.parameterBuffer.put(type, this.parseValue(buffer, type));
        }
    }

    private Object parseValue(ByteBuf parameterBuffer, FirebirdParameterBufferType type) {
        boolean traditionalStyle = this.isTraditionalType.apply(this.version);
        switch (type.getFormat()) {
            case INT: {
                if (traditionalStyle) {
                    parameterBuffer.skipBytes(1);
                } else {
                    parameterBuffer.skipBytes(4);
                }
                return parameterBuffer.readIntLE();
            }
            case BOOLEAN: {
                return true;
            }
            case STRING: {
                int length = traditionalStyle ? parameterBuffer.readByte() : parameterBuffer.readIntLE();
                return parameterBuffer.readSlice(length).toString(StandardCharsets.UTF_8);
            }
        }
        throw new FirebirdProtocolException("Unsupported format type %s", type.getFormat().name());
    }

    public <T> T getValue(FirebirdParameterBufferType key) {
        return (T)this.parameterBuffer.get(key);
    }

    @Generated
    public FirebirdParameterBuffer(Function<Integer, FirebirdParameterBufferType> valueOf, Function<Integer, Boolean> isTraditionalType) {
        this.valueOf = valueOf;
        this.isTraditionalType = isTraditionalType;
    }

    @Generated
    public int getVersion() {
        return this.version;
    }
}

