/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.connector.core.type;

import java.util.Collection;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.metadata.database.metadata.DialectDatabaseMetaData;
import org.apache.shardingsphere.database.connector.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;

public final class DatabaseTypeRegistry {
    private final DatabaseType databaseType;
    private final DialectDatabaseMetaData dialectDatabaseMetaData;

    public DatabaseTypeRegistry(DatabaseType databaseType) {
        this.databaseType = databaseType;
        this.dialectDatabaseMetaData = DatabaseTypedSPILoader.getService(DialectDatabaseMetaData.class, databaseType);
    }

    public Collection<DatabaseType> getAllBranchDatabaseTypes() {
        return ShardingSphereServiceLoader.getServiceInstances(DatabaseType.class).stream().filter(each -> each.getTrunkDatabaseType().map(optional -> optional == this.databaseType).orElse(false)).collect(Collectors.toList());
    }

    public String getDefaultSchemaName(String databaseName) {
        return this.dialectDatabaseMetaData.getSchemaOption().getDefaultSchema().orElse(databaseName);
    }

    public String formatIdentifierPattern(String identifierPattern) {
        switch (this.dialectDatabaseMetaData.getIdentifierPatternType()) {
            case UPPER_CASE: {
                return identifierPattern.toUpperCase();
            }
            case LOWER_CASE: {
                return identifierPattern.toLowerCase();
            }
        }
        return identifierPattern;
    }

    @Generated
    public DialectDatabaseMetaData getDialectDatabaseMetaData() {
        return this.dialectDatabaseMetaData;
    }
}

