/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.mysql.packet.command.query.binary.execute;

import com.google.common.base.Preconditions;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.mysql.constant.MySQLBinaryColumnType;
import org.apache.shardingsphere.database.protocol.mysql.constant.MySQLNewParametersBoundFlag;
import org.apache.shardingsphere.database.protocol.mysql.packet.command.MySQLCommandPacket;
import org.apache.shardingsphere.database.protocol.mysql.packet.command.MySQLCommandPacketType;
import org.apache.shardingsphere.database.protocol.mysql.packet.command.query.MySQLColumnDefinitionFlag;
import org.apache.shardingsphere.database.protocol.mysql.packet.command.query.binary.MySQLPreparedStatementParameterType;
import org.apache.shardingsphere.database.protocol.mysql.packet.command.query.binary.execute.MySQLNullBitmap;
import org.apache.shardingsphere.database.protocol.mysql.packet.command.query.binary.execute.protocol.MySQLBinaryProtocolValue;
import org.apache.shardingsphere.database.protocol.mysql.packet.command.query.binary.execute.protocol.MySQLBinaryProtocolValueFactory;
import org.apache.shardingsphere.database.protocol.mysql.payload.MySQLPacketPayload;

public final class MySQLComStmtExecutePacket
extends MySQLCommandPacket {
    private static final int ITERATION_COUNT = 1;
    private static final int NULL_BITMAP_OFFSET = 0;
    private final MySQLPacketPayload payload;
    private final int statementId;
    private final int flags;
    private final MySQLNullBitmap nullBitmap;
    private final MySQLNewParametersBoundFlag newParametersBoundFlag;
    private final List<MySQLPreparedStatementParameterType> newParameterTypes;

    public MySQLComStmtExecutePacket(MySQLPacketPayload payload, int paramCount) {
        super(MySQLCommandPacketType.COM_STMT_EXECUTE);
        this.payload = payload;
        this.statementId = payload.readInt4();
        this.flags = payload.readInt1();
        Preconditions.checkArgument((1 == payload.readInt4() ? 1 : 0) != 0);
        if (paramCount > 0) {
            this.nullBitmap = new MySQLNullBitmap(paramCount, 0);
            for (int i = 0; i < this.nullBitmap.getNullBitmap().length; ++i) {
                this.nullBitmap.getNullBitmap()[i] = payload.readInt1();
            }
            this.newParametersBoundFlag = MySQLNewParametersBoundFlag.valueOf(payload.readInt1());
            this.newParameterTypes = MySQLNewParametersBoundFlag.PARAMETER_TYPE_EXIST == this.newParametersBoundFlag ? this.getNewParameterTypes(paramCount) : Collections.emptyList();
        } else {
            this.nullBitmap = null;
            this.newParametersBoundFlag = null;
            this.newParameterTypes = Collections.emptyList();
        }
    }

    private List<MySQLPreparedStatementParameterType> getNewParameterTypes(int paramCount) {
        ArrayList<MySQLPreparedStatementParameterType> result = new ArrayList<MySQLPreparedStatementParameterType>(paramCount);
        for (int paramIndex = 0; paramIndex < paramCount; ++paramIndex) {
            MySQLBinaryColumnType columnType = MySQLBinaryColumnType.valueOf(this.payload.readInt1());
            int unsignedFlag = this.payload.readInt1();
            result.add(new MySQLPreparedStatementParameterType(columnType, unsignedFlag));
        }
        return result;
    }

    public List<Object> readParameters(List<MySQLPreparedStatementParameterType> paramTypes, Set<Integer> longDataIndexes, List<Integer> parameterFlags, List<MySQLBinaryColumnType> parameterColumnTypes) throws SQLException {
        ArrayList<Object> result = new ArrayList<Object>(paramTypes.size());
        for (int paramIndex = 0; paramIndex < paramTypes.size(); ++paramIndex) {
            if (longDataIndexes.contains(paramIndex)) {
                result.add(null);
                continue;
            }
            MySQLBinaryColumnType parameterType = paramTypes.get(paramIndex).getColumnType();
            MySQLBinaryProtocolValue binaryProtocolValue = MySQLBinaryProtocolValueFactory.getBinaryProtocolValue(parameterType);
            Object value = this.nullBitmap.isNullParameter(paramIndex) ? null : binaryProtocolValue.read(this.payload, (parameterFlags.get(paramIndex) & MySQLColumnDefinitionFlag.UNSIGNED.getValue()) == MySQLColumnDefinitionFlag.UNSIGNED.getValue());
            value = this.decodeStringParameterValue(parameterColumnTypes, paramIndex, parameterType, value);
            result.add(value);
        }
        return result;
    }

    private Object decodeStringParameterValue(List<MySQLBinaryColumnType> parameterColumnTypes, int paramIndex, MySQLBinaryColumnType parameterType, Object value) {
        if (!(value instanceof byte[]) || MySQLBinaryColumnType.STRING != parameterType || !this.isCharacterColumnType(parameterColumnTypes, paramIndex)) {
            return value;
        }
        return new String((byte[])value, this.payload.getCharset());
    }

    private boolean isCharacterColumnType(List<MySQLBinaryColumnType> parameterColumnTypes, int paramIndex) {
        if (paramIndex >= parameterColumnTypes.size()) {
            return false;
        }
        MySQLBinaryColumnType columnType = parameterColumnTypes.get(paramIndex);
        return MySQLBinaryColumnType.STRING == columnType || MySQLBinaryColumnType.VAR_STRING == columnType || MySQLBinaryColumnType.VARCHAR == columnType;
    }

    @Generated
    public MySQLPacketPayload getPayload() {
        return this.payload;
    }

    @Generated
    public int getStatementId() {
        return this.statementId;
    }

    @Generated
    public int getFlags() {
        return this.flags;
    }

    @Generated
    public MySQLNewParametersBoundFlag getNewParametersBoundFlag() {
        return this.newParametersBoundFlag;
    }

    @Generated
    public List<MySQLPreparedStatementParameterType> getNewParameterTypes() {
        return this.newParameterTypes;
    }
}

