/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.postgresql.handler.admin;

import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.dml.SelectStatementContext;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminExecutor;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminExecutorCreator;
import org.apache.shardingsphere.proxy.backend.postgresql.handler.admin.executor.PostgreSQLResetVariableAdminExecutor;
import org.apache.shardingsphere.proxy.backend.postgresql.handler.admin.executor.PostgreSQLSetVariableAdminExecutor;
import org.apache.shardingsphere.proxy.backend.postgresql.handler.admin.executor.PostgreSQLShowVariableExecutor;
import org.apache.shardingsphere.proxy.backend.postgresql.handler.admin.factory.PostgreSQLSelectAdminExecutorFactory;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dal.SetStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dal.ShowStatement;
import org.apache.shardingsphere.sql.parser.statement.postgresql.dal.PostgreSQLResetParameterStatement;

public final class PostgreSQLAdminExecutorCreator
implements DatabaseAdminExecutorCreator {
    public Optional<DatabaseAdminExecutor> create(SQLStatementContext sqlStatementContext, String sql, String databaseName, List<Object> parameters) {
        if (sqlStatementContext instanceof SelectStatementContext) {
            return PostgreSQLSelectAdminExecutorFactory.newInstance((SelectStatementContext)sqlStatementContext, sql, parameters);
        }
        SQLStatement sqlStatement = sqlStatementContext.getSqlStatement();
        if (sqlStatement instanceof SetStatement) {
            return Optional.of(new PostgreSQLSetVariableAdminExecutor((SetStatement)sqlStatement));
        }
        if (sqlStatement instanceof ShowStatement) {
            return Optional.of(new PostgreSQLShowVariableExecutor((ShowStatement)sqlStatement));
        }
        if (sqlStatement instanceof PostgreSQLResetParameterStatement) {
            return Optional.of(new PostgreSQLResetVariableAdminExecutor((PostgreSQLResetParameterStatement)sqlStatement));
        }
        return Optional.empty();
    }

    public String getDatabaseType() {
        return "PostgreSQL";
    }
}

