/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.mysql.handler.admin.executor.variable.charset;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import org.apache.shardingsphere.database.connector.core.metadata.database.enums.QuoteCharacter;
import org.apache.shardingsphere.database.exception.mysql.exception.UnknownCharsetException;
import org.apache.shardingsphere.database.protocol.mysql.constant.MySQLConstants;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.variable.charset.CharsetVariableProvider;

public final class MySQLCharsetVariableProvider
implements CharsetVariableProvider {
    public Collection<String> getCharsetVariables() {
        return Arrays.asList("charset", "character_set_client");
    }

    public Charset parseCharset(String variableValue) {
        String formattedValue = this.formatValue(variableValue);
        switch (formattedValue.toLowerCase(Locale.ROOT)) {
            case "default": {
                return MySQLConstants.DEFAULT_CHARSET.getCharset();
            }
            case "utf8mb4": {
                return StandardCharsets.UTF_8;
            }
        }
        try {
            return Charset.forName(formattedValue);
        }
        catch (IllegalArgumentException ex) {
            throw new UnknownCharsetException(formattedValue.toLowerCase(Locale.ROOT));
        }
    }

    private String formatValue(String variableValue) {
        return QuoteCharacter.SINGLE_QUOTE.isWrapped(variableValue) || QuoteCharacter.QUOTE.isWrapped(variableValue) ? variableValue.substring(1, variableValue.length() - 1) : variableValue.trim();
    }

    public String getDatabaseType() {
        return "MySQL";
    }
}

