/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.firebird.command.query.statement.execute;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.protocol.binary.BinaryCell;
import org.apache.shardingsphere.database.protocol.binary.BinaryColumnType;
import org.apache.shardingsphere.database.protocol.binary.BinaryRow;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.FirebirdBinaryColumnType;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.statement.execute.FirebirdExecuteStatementPacket;
import org.apache.shardingsphere.database.protocol.firebird.packet.generic.FirebirdGenericResponsePacket;
import org.apache.shardingsphere.database.protocol.firebird.packet.generic.FirebirdSQLResponsePacket;
import org.apache.shardingsphere.database.protocol.packet.DatabasePacket;
import org.apache.shardingsphere.infra.binder.context.aware.ParameterAware;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.handler.ProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.ProxyBackendHandlerFactory;
import org.apache.shardingsphere.proxy.backend.response.data.QueryResponseCell;
import org.apache.shardingsphere.proxy.backend.response.data.QueryResponseRow;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.frontend.command.executor.CommandExecutor;
import org.apache.shardingsphere.proxy.frontend.command.executor.ResponseType;
import org.apache.shardingsphere.proxy.frontend.firebird.command.query.FirebirdServerPreparedStatement;
import org.apache.shardingsphere.proxy.frontend.firebird.command.query.blob.upload.FirebirdBlobUploadCache;
import org.apache.shardingsphere.proxy.frontend.firebird.command.query.statement.fetch.FirebirdFetchStatementCache;

public final class FirebirdExecuteStatementCommandExecutor
implements CommandExecutor {
    private final FirebirdExecuteStatementPacket packet;
    private final ConnectionSession connectionSession;
    private ProxyBackendHandler proxyBackendHandler;
    private ResponseType responseType;

    public Collection<DatabasePacket> execute() throws SQLException {
        FirebirdServerPreparedStatement preparedStatement = (FirebirdServerPreparedStatement)this.connectionSession.getServerPreparedStatementRegistry().getPreparedStatement((Object)this.packet.getStatementId());
        List params = this.packet.getParameterValues();
        List<Long> blobIdsToRemove = this.bindBlobParameters(params);
        SQLStatementContext sqlStatementContext = preparedStatement.getSqlStatementContext();
        if (sqlStatementContext instanceof ParameterAware) {
            ((ParameterAware)sqlStatementContext).bindParameters(params);
        }
        QueryContext queryContext = new QueryContext(sqlStatementContext, preparedStatement.getSql(), params, preparedStatement.getHintValueContext(), this.connectionSession.getConnectionContext(), ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData(), true);
        this.proxyBackendHandler = ProxyBackendHandlerFactory.newInstance((DatabaseType)((DatabaseType)TypedSPILoader.getService(DatabaseType.class, (Object)"Firebird")), (QueryContext)queryContext, (ConnectionSession)this.connectionSession, (boolean)true);
        ResponseHeader responseHeader = this.proxyBackendHandler.execute();
        if (responseHeader instanceof QueryResponseHeader) {
            this.responseType = ResponseType.QUERY;
            FirebirdFetchStatementCache.getInstance().registerStatement(this.connectionSession.getConnectionId(), this.packet.getStatementId(), this.proxyBackendHandler);
            this.connectionSession.getDatabaseConnectionManager().markResourceInUse(this.proxyBackendHandler);
        } else {
            this.responseType = ResponseType.UPDATE;
        }
        if (responseHeader instanceof UpdateResponseHeader) {
            this.clearBlobUploads(blobIdsToRemove);
        }
        LinkedList<DatabasePacket> result = new LinkedList<DatabasePacket>();
        if (this.packet.isStoredProcedure() && this.proxyBackendHandler.next()) {
            result.add((DatabasePacket)this.getSQLResponse());
        }
        result.add((DatabasePacket)new FirebirdGenericResponsePacket());
        return result;
    }

    private List<Long> bindBlobParameters(List<Object> params) {
        List parameterTypes = this.packet.getParameterTypes();
        LinkedList<Long> blobIds = new LinkedList<Long>();
        int paramCount = Math.min(parameterTypes.size(), params.size());
        for (int i = 0; i < paramCount; ++i) {
            if (parameterTypes.get(i) != FirebirdBinaryColumnType.BLOB) continue;
            Object paramValue = params.get(i);
            if (!(paramValue instanceof Long)) {
                params.set(i, null);
                continue;
            }
            long blobId = (Long)paramValue;
            if (blobId <= 0L) {
                params.set(i, null);
                continue;
            }
            if (!FirebirdBlobUploadCache.getInstance().isClosed(this.connectionSession.getConnectionId(), blobId)) {
                params.set(i, null);
                continue;
            }
            Optional<byte[]> blobData = FirebirdBlobUploadCache.getInstance().getBlobData(this.connectionSession.getConnectionId(), blobId);
            byte[] bytes = blobData.get();
            params.set(i, bytes);
            blobIds.add(blobId);
        }
        return blobIds;
    }

    private void clearBlobUploads(List<Long> blobIds) {
        for (Long each : blobIds) {
            FirebirdBlobUploadCache.getInstance().removeUpload(this.connectionSession.getConnectionId(), each);
        }
    }

    private FirebirdSQLResponsePacket getSQLResponse() throws SQLException {
        QueryResponseRow queryResponseRow = this.proxyBackendHandler.getRowData();
        BinaryRow row = this.createBinaryRow(queryResponseRow);
        return new FirebirdSQLResponsePacket(row);
    }

    private BinaryRow createBinaryRow(QueryResponseRow queryResponseRow) {
        ArrayList<BinaryCell> result = new ArrayList<BinaryCell>(queryResponseRow.getCells().size());
        for (QueryResponseCell each : queryResponseRow.getCells()) {
            result.add(new BinaryCell((BinaryColumnType)FirebirdBinaryColumnType.valueOfJDBCType((int)each.getJdbcType()), each.getData()));
        }
        return new BinaryRow(result);
    }

    @Generated
    public FirebirdExecuteStatementCommandExecutor(FirebirdExecuteStatementPacket packet, ConnectionSession connectionSession) {
        this.packet = packet;
        this.connectionSession = connectionSession;
    }

    @Generated
    public ResponseType getResponseType() {
        return this.responseType;
    }
}

