/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.firebird;

import lombok.Generated;
import org.apache.shardingsphere.database.exception.core.exception.transaction.InTransactionException;
import org.apache.shardingsphere.database.protocol.codec.DatabasePacketCodecEngine;
import org.apache.shardingsphere.database.protocol.firebird.codec.FirebirdPacketCodecEngine;
import org.apache.shardingsphere.database.protocol.firebird.constant.protocol.FirebirdConnectionProtocolVersion;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.frontend.authentication.AuthenticationEngine;
import org.apache.shardingsphere.proxy.frontend.firebird.authentication.FirebirdAuthenticationEngine;
import org.apache.shardingsphere.proxy.frontend.firebird.command.FirebirdCommandExecuteEngine;
import org.apache.shardingsphere.proxy.frontend.firebird.command.query.blob.FirebirdBlobIdGenerator;
import org.apache.shardingsphere.proxy.frontend.firebird.command.query.blob.upload.FirebirdBlobUploadCache;
import org.apache.shardingsphere.proxy.frontend.firebird.command.query.statement.FirebirdStatementIdGenerator;
import org.apache.shardingsphere.proxy.frontend.firebird.command.query.statement.fetch.FirebirdFetchStatementCache;
import org.apache.shardingsphere.proxy.frontend.firebird.command.query.transaction.FirebirdTransactionIdGenerator;
import org.apache.shardingsphere.proxy.frontend.spi.DatabaseProtocolFrontendEngine;

public final class FirebirdFrontendEngine
implements DatabaseProtocolFrontendEngine {
    private final AuthenticationEngine authenticationEngine = new FirebirdAuthenticationEngine();
    private final FirebirdCommandExecuteEngine commandExecuteEngine = new FirebirdCommandExecuteEngine();
    private final DatabasePacketCodecEngine codecEngine = new FirebirdPacketCodecEngine();

    public void release(ConnectionSession connectionSession) {
        FirebirdStatementIdGenerator.getInstance().unregisterConnection(connectionSession.getConnectionId());
        FirebirdTransactionIdGenerator.getInstance().unregisterConnection(connectionSession.getConnectionId());
        FirebirdBlobIdGenerator.getInstance().unregisterConnection(connectionSession.getConnectionId());
        FirebirdBlobUploadCache.getInstance().unregisterConnection(connectionSession.getConnectionId());
        FirebirdConnectionProtocolVersion.getInstance().unsetProtocolVersion(connectionSession.getConnectionId());
        FirebirdFetchStatementCache.getInstance().unregisterConnection(connectionSession.getConnectionId());
    }

    public void handleException(ConnectionSession connectionSession, Exception exception) {
        if (connectionSession.getTransactionStatus().isInTransaction() && !connectionSession.getConnectionContext().getTransactionContext().isExceptionOccur() && !(exception instanceof InTransactionException)) {
            connectionSession.getConnectionContext().getTransactionContext().setExceptionOccur(true);
        }
    }

    public String getDatabaseType() {
        return "Firebird";
    }

    @Generated
    public AuthenticationEngine getAuthenticationEngine() {
        return this.authenticationEngine;
    }

    @Generated
    public FirebirdCommandExecuteEngine getCommandExecuteEngine() {
        return this.commandExecuteEngine;
    }

    @Generated
    public DatabasePacketCodecEngine getCodecEngine() {
        return this.codecEngine;
    }
}

