/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.transaction;

import java.util.Map;
import javax.sql.DataSource;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.transaction.api.TransactionType;
import org.apache.shardingsphere.transaction.exception.TransactionManagerNotFoundException;
import org.apache.shardingsphere.transaction.spi.ShardingSphereDistributedTransactionManager;

public final class ShardingSphereTransactionManagerEngine {
    private final TransactionType transactionType;
    private final ShardingSphereDistributedTransactionManager distributedTransactionManager;

    public ShardingSphereTransactionManagerEngine(TransactionType transactionType) {
        this.transactionType = transactionType;
        this.distributedTransactionManager = TransactionType.LOCAL == transactionType ? null : (ShardingSphereDistributedTransactionManager)TypedSPILoader.getService(ShardingSphereDistributedTransactionManager.class, (Object)transactionType.name());
    }

    public void init(Map<String, DatabaseType> databaseTypes, Map<String, DataSource> dataSourceMap, String providerType) {
        if (TransactionType.LOCAL == this.transactionType) {
            return;
        }
        this.distributedTransactionManager.init(databaseTypes, dataSourceMap, providerType);
    }

    public ShardingSphereDistributedTransactionManager getTransactionManager(TransactionType transactionType) {
        if (TransactionType.LOCAL != transactionType) {
            ShardingSpherePreconditions.checkNotNull((Object)this.distributedTransactionManager, () -> new TransactionManagerNotFoundException(transactionType));
        }
        return this.distributedTransactionManager;
    }

    public void close() {
        if (TransactionType.LOCAL == this.transactionType) {
            return;
        }
        this.distributedTransactionManager.close();
    }
}

