/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator.select;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.metadata.database.enums.QuoteCharacter;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.column.EncryptColumn;
import org.apache.shardingsphere.encrypt.rule.table.EncryptTable;
import org.apache.shardingsphere.infra.binder.context.segment.select.groupby.GroupByContext;
import org.apache.shardingsphere.infra.binder.context.segment.select.orderby.OrderByItem;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.SQLToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.generic.SubstitutableColumnNameToken;
import org.apache.shardingsphere.sql.parser.statement.core.enums.TableSourceType;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.item.ColumnOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class EncryptGroupByItemTokenGenerator
implements CollectionSQLTokenGenerator<SelectStatementContext> {
    private final EncryptRule rule;

    public boolean isGenerateSQLToken(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof SelectStatementContext && this.containsGroupByItem((SelectStatementContext)sqlStatementContext);
    }

    private boolean containsGroupByItem(SelectStatementContext sqlStatementContext) {
        if (!sqlStatementContext.getGroupByContext().getItems().isEmpty()) {
            return true;
        }
        for (SelectStatementContext each : sqlStatementContext.getSubqueryContexts().values()) {
            if (!this.containsGroupByItem(each)) continue;
            return true;
        }
        return false;
    }

    public Collection<SQLToken> generateSQLTokens(SelectStatementContext sqlStatementContext) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        for (GroupByContext each : this.getGroupByItems(sqlStatementContext)) {
            for (OrderByItem item : each.getItems()) {
                if (!(item.getSegment() instanceof ColumnOrderByItemSegment)) continue;
                ColumnSegment columnSegment = ((ColumnOrderByItemSegment)item.getSegment()).getColumn();
                this.generateSQLToken(columnSegment, sqlStatementContext.getSqlStatement().getDatabaseType()).ifPresent(result::add);
            }
        }
        return result;
    }

    private Optional<SubstitutableColumnNameToken> generateSQLToken(ColumnSegment columnSegment, DatabaseType databaseType) {
        Optional<EncryptTable> encryptTable = this.rule.findEncryptTable(columnSegment.getColumnBoundInfo().getOriginalTable().getValue());
        String columnName = columnSegment.getColumnBoundInfo().getOriginalColumn().getValue();
        if (!encryptTable.isPresent() || !encryptTable.get().isEncryptColumn(columnName)) {
            return Optional.empty();
        }
        EncryptColumn encryptColumn = encryptTable.get().getEncryptColumn(columnName);
        int startIndex = columnSegment.getOwner().isPresent() ? ((OwnerSegment)columnSegment.getOwner().get()).getStopIndex() + 2 : columnSegment.getStartIndex();
        int stopIndex = columnSegment.getStopIndex();
        QuoteCharacter quoteCharacter = this.getQuoteCharacter(columnSegment, databaseType);
        return Optional.of(encryptColumn.getAssistedQuery().map(optional -> new SubstitutableColumnNameToken(startIndex, stopIndex, this.createColumnProjections(optional.getName(), quoteCharacter, databaseType), databaseType)).orElseGet(() -> new SubstitutableColumnNameToken(startIndex, stopIndex, this.createColumnProjections(encryptColumn.getCipher().getName(), quoteCharacter, databaseType), databaseType)));
    }

    private Collection<GroupByContext> getGroupByItems(SelectStatementContext sqlStatementContext) {
        LinkedList<GroupByContext> result = new LinkedList<GroupByContext>();
        result.add(sqlStatementContext.getGroupByContext());
        for (SelectStatementContext each : sqlStatementContext.getSubqueryContexts().values()) {
            result.addAll(this.getGroupByItems(each));
        }
        return result;
    }

    private QuoteCharacter getQuoteCharacter(ColumnSegment columnSegment, DatabaseType databaseType) {
        return TableSourceType.PHYSICAL_TABLE == columnSegment.getColumnBoundInfo().getTableSourceType() ? new DatabaseTypeRegistry(databaseType).getDialectDatabaseMetaData().getQuoteCharacter() : columnSegment.getIdentifier().getQuoteCharacter();
    }

    private Collection<Projection> createColumnProjections(String columnName, QuoteCharacter quoteCharacter, DatabaseType databaseType) {
        return Collections.singleton(new ColumnProjection(null, new IdentifierValue(columnName, quoteCharacter), null, databaseType));
    }

    @Generated
    public EncryptGroupByItemTokenGenerator(EncryptRule rule) {
        this.rule = rule;
    }
}

