/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.cdc.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.cdc.protocol.request.StreamDataRequestBody;
import org.apache.shardingsphere.database.connector.core.metadata.database.metadata.DialectDatabaseMetaData;
import org.apache.shardingsphere.database.connector.core.metadata.database.system.DialectSystemDatabase;
import org.apache.shardingsphere.database.connector.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.metadata.SchemaNotFoundException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.TableNotFoundException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;

public final class CDCSchemaTableUtils {
    public static Map<String, Set<String>> parseTableExpressionWithSchema(ShardingSphereDatabase database, Collection<StreamDataRequestBody.SchemaTable> schemaTables) {
        Collection systemSchemas = ((DialectSystemDatabase)DatabaseTypedSPILoader.getService(DialectSystemDatabase.class, (DatabaseType)database.getProtocolType())).getSystemSchemas();
        if (schemaTables.stream().anyMatch(each -> "*".equals(each.getTable()) && ("*".equals(each.getSchema()) || each.getSchema().isEmpty()))) {
            return CDCSchemaTableUtils.parseTableExpressionWithAllTables(database, systemSchemas);
        }
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        DialectDatabaseMetaData dialectDatabaseMetaData = new DatabaseTypeRegistry(database.getProtocolType()).getDialectDatabaseMetaData();
        for (StreamDataRequestBody.SchemaTable each2 : schemaTables) {
            if ("*".equals(each2.getSchema())) {
                result.putAll(CDCSchemaTableUtils.parseTableExpressionWithAllSchema(database, systemSchemas, each2));
                continue;
            }
            if ("*".equals(each2.getTable())) {
                result.putAll(CDCSchemaTableUtils.parseTableExpressionWithAllTable(database, each2));
                continue;
            }
            String schemaName = each2.getSchema();
            if (dialectDatabaseMetaData.getSchemaOption().getDefaultSchema().isPresent() && schemaName.isEmpty()) {
                schemaName = (String)dialectDatabaseMetaData.getSchemaOption().getDefaultSchema().get();
            }
            ShardingSpherePreconditions.checkNotNull((Object)database.getSchema(schemaName).getTable(each2.getTable()), () -> new TableNotFoundException(each2.getTable()));
            result.computeIfAbsent(schemaName, ignored -> new HashSet()).add(each2.getTable());
        }
        return result;
    }

    private static Map<String, Set<String>> parseTableExpressionWithAllTables(ShardingSphereDatabase database, Collection<String> systemSchemas) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>(database.getAllSchemas().size(), 1.0f);
        for (ShardingSphereSchema schema : database.getAllSchemas()) {
            if (systemSchemas.contains(schema.getName())) continue;
            schema.getAllTables().forEach(each -> result.computeIfAbsent(schema.getName(), ignored -> new HashSet()).add(each.getName()));
        }
        return result;
    }

    private static Map<String, Set<String>> parseTableExpressionWithAllSchema(ShardingSphereDatabase database, Collection<String> systemSchemas, StreamDataRequestBody.SchemaTable table) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>(database.getAllSchemas().size(), 1.0f);
        for (ShardingSphereSchema schema : database.getAllSchemas()) {
            if (systemSchemas.contains(schema.getName())) continue;
            schema.getAllTables().stream().filter(each -> each.getName().equals(table.getTable())).findFirst().ifPresent(optional -> result.computeIfAbsent(schema.getName(), ignored -> new HashSet()).add(optional.getName()));
        }
        return result;
    }

    private static Map<String, Set<String>> parseTableExpressionWithAllTable(ShardingSphereDatabase database, StreamDataRequestBody.SchemaTable schemaTable) {
        String schemaName = schemaTable.getSchema();
        ShardingSphereSchema schema = database.getSchema(schemaName);
        ShardingSpherePreconditions.checkNotNull((Object)schema, () -> new SchemaNotFoundException(schemaTable.getSchema()));
        Collection tables = schema.getAllTables();
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>(tables.size(), 1.0f);
        tables.forEach(each -> result.computeIfAbsent(schemaName, ignored -> new HashSet()).add(each.getName()));
        return result;
    }

    public static Collection<String> parseTableExpressionWithoutSchema(ShardingSphereDatabase database, List<String> tableNames) {
        ShardingSphereSchema schema = database.getSchema(database.getName());
        HashSet<String> allTableNames = null == schema ? Collections.emptySet() : new HashSet<String>(schema.getAllTables().stream().map(ShardingSphereTable::getName).collect(Collectors.toSet()));
        return tableNames.stream().anyMatch("*"::equals) ? allTableNames : new HashSet<String>(tableNames);
    }

    @Generated
    private CDCSchemaTableUtils() {
    }
}

