/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.postgresql.sqlbuilder.ddl.constraints;

import java.sql.Connection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.shardingsphere.data.pipeline.postgresql.sqlbuilder.ddl.PostgreSQLDDLTemplateExecutor;

public final class PostgreSQLConstraintsPropertiesAppender {
    private static final Integer PG_CONSTRAINTS_INCLUDE_VERSION = 11;
    private final PostgreSQLDDLTemplateExecutor templateExecutor;

    public PostgreSQLConstraintsPropertiesAppender(Connection connection, int majorVersion, int minorVersion) {
        this.templateExecutor = new PostgreSQLDDLTemplateExecutor(connection, majorVersion, minorVersion);
    }

    public void append(Map<String, Object> context) {
        this.loadPrimaryOrUniqueConstraint(context, "primary_key", "p");
        this.loadPrimaryOrUniqueConstraint(context, "unique_constraint", "u");
        context.put("foreign_key", this.fetchForeignKeys(context));
        context.put("check_constraint", this.fetchCheckConstraints(context));
        context.put("exclude_constraint", this.getExclusionConstraints(context));
    }

    private void loadPrimaryOrUniqueConstraint(Map<String, Object> context, String name, String type) {
        Collection<Map<String, Object>> constraintsProps = this.fetchConstraintsProperties(context, type);
        this.fetchConstraintsColumns(constraintsProps);
        context.put(name, constraintsProps.stream().filter(each -> !this.isPartitionAndConstraintInherited((Map<String, Object>)each, context)).collect(Collectors.toList()));
    }

    private Collection<Map<String, Object>> fetchConstraintsProperties(Map<String, Object> context, String constraintType) {
        HashMap<String, Object> params = new HashMap<String, Object>(4, 1.0f);
        params.put("did", context.get("did"));
        params.put("tid", context.get("tid"));
        params.put("cid", context.get("cid"));
        params.put("constraint_type", constraintType);
        return this.templateExecutor.executeByTemplate(params, "component/index_constraint/%s/properties.ftl");
    }

    private void fetchConstraintsColumns(Collection<Map<String, Object>> constraintsProps) {
        for (Map<String, Object> each : constraintsProps) {
            each.put("columns", this.fetchConstraintsCols(each).stream().map(col -> Collections.singletonMap("column", this.stripQuote((String)col.get("column")))).collect(Collectors.toList()));
            this.appendConstraintsInclude(each);
        }
    }

    private void appendConstraintsInclude(Map<String, Object> constraintsProp) {
        List includes = this.templateExecutor.getMajorVersion() >= PG_CONSTRAINTS_INCLUDE_VERSION ? (Collection)this.templateExecutor.executeByTemplate(Collections.singletonMap("cid", constraintsProp.get("oid")), "component/index_constraint/%s/get_constraint_include.ftl").stream().map(each -> each.get("colname")).collect(Collectors.toList()) : Collections.emptyList();
        constraintsProp.put("include", includes);
    }

    private String stripQuote(String column) {
        String result = column;
        if (column.startsWith("\"")) {
            result = result.substring(1);
        }
        if (column.endsWith("\"")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    private Collection<Map<String, Object>> fetchConstraintsCols(Map<String, Object> constraintColProps) {
        HashMap<String, Object> params = new HashMap<String, Object>(2, 1.0f);
        params.put("cid", constraintColProps.get("oid"));
        params.put("colcnt", constraintColProps.get("col_count"));
        return this.templateExecutor.executeByTemplate(params, "component/index_constraint/%s/get_costraint_cols.ftl");
    }

    private Collection<Map<String, Object>> fetchForeignKeys(Map<String, Object> context) {
        return this.getForeignKeys((Long)context.get("tid")).stream().filter(each -> !this.isPartitionAndConstraintInherited((Map<String, Object>)each, context)).collect(Collectors.toList());
    }

    private Collection<Map<String, Object>> fetchCheckConstraints(Map<String, Object> context) {
        return this.getCheckConstraints((Long)context.get("tid")).stream().filter(each -> !this.isPartitionAndConstraintInherited((Map<String, Object>)each, context)).collect(Collectors.toList());
    }

    private Collection<Map<String, Object>> getExclusionConstraints(Map<String, Object> context) {
        HashMap<String, Object> params = new HashMap<String, Object>(2, 1.0f);
        params.put("tid", context.get("tid"));
        params.put("did", context.get("did"));
        Collection<Map<String, Object>> result = this.templateExecutor.executeByTemplate(params, "component/exclusion_constraint/%s/properties.ftl");
        for (Map<String, Object> each : result) {
            this.getExclusionConstraintsColumns(each);
        }
        return result;
    }

    private void getExclusionConstraintsColumns(Map<String, Object> exclusionConstraintsProps) {
        HashMap<String, Object> params = new HashMap<String, Object>(2, 1.0f);
        params.put("cid", exclusionConstraintsProps.get("oid"));
        params.put("col_count", exclusionConstraintsProps.get("col_count"));
        LinkedList columns = new LinkedList();
        for (Map<String, Object> each : this.templateExecutor.executeByTemplate(params, "component/exclusion_constraint/%s/get_constraint_cols.ftl")) {
            boolean order = 0 == ((Integer)each.get("options") & 1);
            boolean nullsOrder = 0 != ((Integer)each.get("options") & 2);
            HashMap<String, Object> col = new HashMap<String, Object>(7, 1.0f);
            col.put("column", this.strip((String)each.get("coldef")));
            col.put("oper_class", each.get("opcname"));
            col.put("order", order);
            col.put("nulls_order", nullsOrder);
            col.put("operator", each.get("oprname"));
            col.put("col_type", each.get("datatype"));
            col.put("is_exp", each.get("is_exp"));
            columns.add(col);
        }
        exclusionConstraintsProps.put("columns", columns);
        LinkedList<String> include = new LinkedList<String>();
        if (this.templateExecutor.getMajorVersion() >= PG_CONSTRAINTS_INCLUDE_VERSION) {
            Map<String, Object> map = Collections.singletonMap("cid", exclusionConstraintsProps.get("oid"));
            for (Map<String, Object> each : this.templateExecutor.executeByTemplate(map, "exclusion_constraint/%s/get_constraint_include.ftl")) {
                include.add(each.get("colname").toString());
            }
        }
        exclusionConstraintsProps.put("include", include);
    }

    private Collection<Map<String, Object>> getForeignKeys(Long tid) {
        Collection<Map<String, Object>> result = this.templateExecutor.executeByTemplate(Collections.singletonMap("tid", tid), "component/foreign_key/%s/properties.ftl");
        for (Map<String, Object> each : result) {
            LinkedList<Map<String, Object>> columns = new LinkedList<Map<String, Object>>();
            HashSet<String> cols = new HashSet<String>();
            for (Map<String, Object> col : this.getForeignKeysCols(tid, each)) {
                HashMap<String, Object> foreignKeysRef = new HashMap<String, Object>(4, 1.0f);
                foreignKeysRef.put("local_column", col.get("conattname"));
                foreignKeysRef.put("references", each.get("confrelid"));
                foreignKeysRef.put("referenced", col.get("confattname"));
                foreignKeysRef.put("references_table_name", each.get("refnsp") + "." + each.get("reftab"));
                columns.add(foreignKeysRef);
                cols.add((String)col.get("conattname"));
            }
            this.setRemoteName(each, columns);
            Optional<String> coveringIndex = this.searchCoveringIndex(tid, cols);
            each.put("coveringindex", coveringIndex.orElse(null));
            each.put("autoindex", !coveringIndex.isPresent());
            each.put("hasindex", coveringIndex.isPresent());
            each.put("columns", columns);
        }
        return result;
    }

    private void setRemoteName(Map<String, Object> foreignKey, Collection<Map<String, Object>> columns) {
        Map<String, Object> parents = this.templateExecutor.executeByTemplateForSingleRow(Collections.singletonMap("tid", columns.iterator().next().get("references")), "component/foreign_key/%s/get_parent.ftl");
        foreignKey.put("remote_schema", parents.get("schema"));
        foreignKey.put("remote_table", parents.get("table"));
    }

    private Collection<Map<String, Object>> getForeignKeysCols(Long tid, Map<String, Object> foreignKeyProps) {
        HashMap<String, Object> params = new HashMap<String, Object>(2, 1.0f);
        params.put("tid", tid);
        HashMap<String, Object> key = new HashMap<String, Object>(2, 1.0f);
        key.put("confkey", foreignKeyProps.get("confkey"));
        key.put("conkey", foreignKeyProps.get("conkey"));
        params.put("keys", Collections.singleton(key));
        return this.templateExecutor.executeByTemplate(params, "component/foreign_key/%s/get_constraint_cols.ftl");
    }

    private boolean isPartitionAndConstraintInherited(Map<String, Object> constraint, Map<String, Object> context) {
        return context.containsKey("relispartition") && (Boolean)context.get("relispartition") != false && constraint.containsKey("conislocal") && (Boolean)constraint.get("conislocal") != false;
    }

    private Optional<String> searchCoveringIndex(Long tid, Set<String> cols) {
        for (Map<String, Object> each : this.templateExecutor.executeByTemplate(Collections.singletonMap("tid", tid), "component/foreign_key/%s/get_constraints.ftl")) {
            HashMap<String, Object> map = new HashMap<String, Object>(2, 1.0f);
            map.put("cid", each.get("oid"));
            map.put("colcnt", each.get("col_count"));
            Collection<Map<String, Object>> rows = this.templateExecutor.executeByTemplate(map, "component/foreign_key/%s/get_cols.ftl");
            HashSet<String> indexCols = new HashSet<String>(rows.size(), 1.0f);
            for (Map<String, Object> row : rows) {
                indexCols.add(this.strip(row.get("column").toString()));
            }
            if (!this.isSame(indexCols, cols)) continue;
            return Optional.of((String)each.get("idxname"));
        }
        return Optional.empty();
    }

    private boolean isSame(Set<String> indexCols, Set<String> cols) {
        HashSet<String> copyIndexCols = new HashSet<String>(indexCols);
        HashSet<String> copyCols = new HashSet<String>(cols);
        copyIndexCols.removeAll(copyCols);
        if (copyIndexCols.isEmpty()) {
            cols.removeAll(indexCols);
            return cols.isEmpty();
        }
        return false;
    }

    private String strip(String column) {
        if (column.startsWith("\"")) {
            return column.substring(1);
        }
        if (column.endsWith("\"")) {
            return column.substring(0, column.length() - 1);
        }
        return column;
    }

    private Collection<Map<String, Object>> getCheckConstraints(Long tid) {
        return this.templateExecutor.executeByTemplate(Collections.singletonMap("tid", tid), "component/check_constraint/%s/properties.ftl");
    }
}

