/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.database.datasource;

import lombok.Generated;
import org.apache.shardingsphere.mode.event.DataChangedEvent;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.database.DatabaseLeafValueChangedHandler;
import org.apache.shardingsphere.mode.node.path.NodePath;
import org.apache.shardingsphere.mode.node.path.engine.searcher.NodePathSearchCriteria;
import org.apache.shardingsphere.mode.node.path.engine.searcher.NodePathSearcher;
import org.apache.shardingsphere.mode.node.path.type.database.metadata.datasource.StorageNodeNodePath;

public final class StorageNodeChangedHandler
implements DatabaseLeafValueChangedHandler {
    private final ContextManager contextManager;

    @Override
    public NodePath getSubscribedNodePath(String databaseName) {
        return new StorageNodeNodePath(databaseName, "([\\w-]+)");
    }

    @Override
    public void handle(String databaseName, DataChangedEvent event) {
        String storageNodeName = NodePathSearcher.get((String)event.getKey(), (NodePathSearchCriteria)StorageNodeNodePath.createStorageNodeSearchCriteria((String)databaseName));
        switch (event.getType()) {
            case ADDED: {
                this.handleRegistered(databaseName, storageNodeName);
                break;
            }
            case UPDATED: {
                this.handleAltered(databaseName, storageNodeName);
                break;
            }
            case DELETED: {
                this.handleUnregistered(databaseName, storageNodeName);
                break;
            }
        }
    }

    private void handleRegistered(String databaseName, String storageNodeName) {
    }

    private void handleAltered(String databaseName, String storageNodeName) {
    }

    private void handleUnregistered(String databaseName, String storageNodeName) {
    }

    @Generated
    public StorageNodeChangedHandler(ContextManager contextManager) {
        this.contextManager = contextManager;
    }
}

