/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.executor.enumerable.enumerator.jdbc;

import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Collection;
import lombok.Generated;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.shardingsphere.infra.exception.external.sql.type.wrapper.SQLWrapperException;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.driver.jdbc.type.util.ResultSetUtils;
import org.apache.shardingsphere.infra.merge.result.MergedResult;

public final class JDBCDataRowEnumerator
implements Enumerator<Object> {
    private final MergedResult queryResult;
    private final QueryResultMetaData metaData;
    private final Collection<Statement> statements;
    private Object currentRow;

    public Object current() {
        return this.currentRow;
    }

    public boolean moveNext() {
        if (this.queryResult.next()) {
            this.setCurrentRow();
            return true;
        }
        return false;
    }

    private void setCurrentRow() throws SQLException {
        Object[] rowValues = new Object[this.metaData.getColumnCount()];
        for (int i = 0; i < this.metaData.getColumnCount(); ++i) {
            rowValues[i] = this.getValue(i);
        }
        this.currentRow = 1 == this.metaData.getColumnCount() ? rowValues[0] : rowValues;
    }

    private Object getValue(int index) throws SQLException {
        Object result = this.queryResult.getValue(index + 1, Object.class);
        return result instanceof LocalDateTime ? ResultSetUtils.convertValue((Object)result, Timestamp.class) : result;
    }

    public void reset() {
    }

    public void close() {
        try {
            for (Statement each : this.statements) {
                each.close();
            }
            this.currentRow = null;
        }
        catch (SQLException ex) {
            throw new SQLWrapperException(ex);
        }
    }

    @Generated
    public JDBCDataRowEnumerator(MergedResult queryResult, QueryResultMetaData metaData, Collection<Statement> statements) {
        this.queryResult = queryResult;
        this.metaData = metaData;
        this.statements = statements;
    }
}

