/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.broadcast.rule;

import com.cedarsoftware.util.CaseInsensitiveSet;
import java.util.Collection;
import java.util.Map;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.broadcast.config.BroadcastRuleConfiguration;
import org.apache.shardingsphere.broadcast.rule.attribute.BroadcastDataNodeRuleAttribute;
import org.apache.shardingsphere.broadcast.rule.attribute.BroadcastTableNamesRuleAttribute;
import org.apache.shardingsphere.broadcast.rule.attribute.BroadcastUnregisterStorageUnitRuleAttribute;
import org.apache.shardingsphere.infra.metadata.database.resource.PhysicalDataSourceAggregator;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.attribute.RuleAttribute;
import org.apache.shardingsphere.infra.rule.attribute.RuleAttributes;
import org.apache.shardingsphere.infra.rule.attribute.datasource.aggregate.AggregatedDataSourceRuleAttribute;
import org.apache.shardingsphere.infra.rule.scope.DatabaseRule;

public final class BroadcastRule
implements DatabaseRule {
    private final BroadcastRuleConfiguration configuration;
    private final Collection<String> dataSourceNames;
    private final Collection<String> tables;
    private final RuleAttributes attributes;

    public BroadcastRule(BroadcastRuleConfiguration ruleConfig, Map<String, DataSource> dataSources, Collection<ShardingSphereRule> builtRules) {
        this.configuration = ruleConfig;
        Map aggregatedDataSources = new RuleMetaData(builtRules).findAttribute(AggregatedDataSourceRuleAttribute.class).map(AggregatedDataSourceRuleAttribute::getAggregatedDataSources).orElseGet(() -> PhysicalDataSourceAggregator.getAggregatedDataSources((Map)dataSources, (Collection)builtRules));
        this.dataSourceNames = new CaseInsensitiveSet(aggregatedDataSources.keySet());
        this.tables = new CaseInsensitiveSet(ruleConfig.getTables());
        this.attributes = new RuleAttributes(new RuleAttribute[]{new BroadcastDataNodeRuleAttribute(this.dataSourceNames, this.tables), new BroadcastTableNamesRuleAttribute(this.tables), new AggregatedDataSourceRuleAttribute(aggregatedDataSources), new BroadcastUnregisterStorageUnitRuleAttribute()});
    }

    public Collection<String> getBroadcastTableNames(Collection<String> logicTableNames) {
        CaseInsensitiveSet result = new CaseInsensitiveSet();
        for (String each : logicTableNames) {
            if (!this.tables.contains(each)) continue;
            result.add(each);
        }
        return result;
    }

    public int getOrder() {
        return 15;
    }

    @Generated
    public BroadcastRuleConfiguration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public Collection<String> getDataSourceNames() {
        return this.dataSourceNames;
    }

    @Generated
    public Collection<String> getTables() {
        return this.tables;
    }

    @Generated
    public RuleAttributes getAttributes() {
        return this.attributes;
    }
}

