/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rule.changed;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import org.apache.shardingsphere.encrypt.config.EncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.config.rule.EncryptTableRuleConfiguration;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.yaml.config.rule.YamlEncryptTableRuleConfiguration;
import org.apache.shardingsphere.encrypt.yaml.swapper.rule.YamlEncryptTableRuleConfigurationSwapper;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.mode.spi.rule.RuleChangedItemType;
import org.apache.shardingsphere.mode.spi.rule.RuleItemConfigurationChangedProcessor;

public final class EncryptTableChangedProcessor
implements RuleItemConfigurationChangedProcessor<EncryptRuleConfiguration, EncryptTableRuleConfiguration> {
    public EncryptTableRuleConfiguration swapRuleItemConfiguration(String itemName, String yamlContent) {
        return new YamlEncryptTableRuleConfigurationSwapper().swapToObject((YamlEncryptTableRuleConfiguration)YamlEngine.unmarshal((String)yamlContent, YamlEncryptTableRuleConfiguration.class));
    }

    public EncryptRuleConfiguration findRuleConfiguration(ShardingSphereDatabase database) {
        return database.getRuleMetaData().findSingleRule(EncryptRule.class).map(EncryptRule::getConfiguration).orElseGet(() -> new EncryptRuleConfiguration(new LinkedList(), new LinkedHashMap()));
    }

    public void changeRuleItemConfiguration(String itemName, EncryptRuleConfiguration currentRuleConfig, EncryptTableRuleConfiguration toBeChangedItemConfig) {
        currentRuleConfig.getTables().removeIf(each -> each.getName().equals(toBeChangedItemConfig.getName()));
        currentRuleConfig.getTables().add(toBeChangedItemConfig);
    }

    public void dropRuleItemConfiguration(String itemName, EncryptRuleConfiguration currentRuleConfig) {
        currentRuleConfig.getTables().removeIf(each -> each.getName().equals(itemName));
    }

    public RuleChangedItemType getType() {
        return new RuleChangedItemType("encrypt", "tables");
    }
}

