/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.refresher.pushdown.type.view;

import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.GenericSchemaBuilder;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.GenericSchemaBuilderMaterial;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereView;
import org.apache.shardingsphere.infra.rule.attribute.datanode.MutableDataNodeRuleAttribute;
import org.apache.shardingsphere.mode.metadata.refresher.pushdown.PushDownMetaDataRefresher;
import org.apache.shardingsphere.mode.metadata.refresher.util.TableRefreshUtils;
import org.apache.shardingsphere.mode.persist.service.MetaDataManagerPersistService;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.view.AlterViewStatement;

public final class AlterViewPushDownMetaDataRefresher
implements PushDownMetaDataRefresher<AlterViewStatement> {
    @Override
    public void refresh(MetaDataManagerPersistService metaDataManagerPersistService, ShardingSphereDatabase database, String logicDataSourceName, String schemaName, DatabaseType databaseType, AlterViewStatement sqlStatement, ConfigurationProperties props) throws SQLException {
        Optional viewDefinition;
        String viewName = TableRefreshUtils.getTableName(sqlStatement.getView().getTableName().getIdentifier(), databaseType);
        LinkedList<ShardingSphereTable> alteredTables = new LinkedList<ShardingSphereTable>();
        LinkedList<String> droppedTables = new LinkedList<String>();
        Optional renameView = sqlStatement.getRenameView();
        if (renameView.isPresent()) {
            String renameViewName = ((SimpleTableSegment)renameView.get()).getTableName().getIdentifier().getValue();
            String originalView = database.getSchema(schemaName).getView(viewName).getViewDefinition();
            ShardingSphereSchema schema = this.getSchema(database, logicDataSourceName, schemaName, renameViewName, originalView, props);
            alteredTables.add(schema.getTable(renameViewName));
            droppedTables.add(viewName);
        }
        if ((viewDefinition = sqlStatement.getViewDefinition()).isPresent()) {
            ShardingSphereSchema schema = this.getSchema(database, logicDataSourceName, schemaName, viewName, (String)viewDefinition.get(), props);
            alteredTables.add(schema.getTable(viewName));
        }
        metaDataManagerPersistService.alterTables(database, schemaName, alteredTables);
        metaDataManagerPersistService.dropTables(database, schemaName, droppedTables);
    }

    private ShardingSphereSchema getSchema(ShardingSphereDatabase database, String logicDataSourceName, String schemaName, String viewName, String viewDefinition, ConfigurationProperties props) throws SQLException {
        RuleMetaData ruleMetaData = new RuleMetaData(new LinkedList(database.getRuleMetaData().getRules()));
        if (TableRefreshUtils.isSingleTable(viewName, database)) {
            ruleMetaData.getAttributes(MutableDataNodeRuleAttribute.class).forEach(each -> each.put(logicDataSourceName, schemaName, viewName));
        }
        GenericSchemaBuilderMaterial material = new GenericSchemaBuilderMaterial(database.getResourceMetaData().getStorageUnits(), ruleMetaData.getRules(), props, schemaName);
        Map schemas = GenericSchemaBuilder.build(Collections.singletonList(viewName), (DatabaseType)database.getProtocolType(), (GenericSchemaBuilderMaterial)material);
        Optional<ShardingSphereTable> actualViewMetaData = Optional.ofNullable((ShardingSphereSchema)schemas.get(schemaName)).map(optional -> optional.getTable(viewName));
        ShardingSphereSchema result = new ShardingSphereSchema(schemaName, database.getProtocolType());
        actualViewMetaData.ifPresent(arg_0 -> ((ShardingSphereSchema)result).putTable(arg_0));
        result.putView(new ShardingSphereView(viewName, viewDefinition));
        return result;
    }

    @Override
    public Class<AlterViewStatement> getType() {
        return AlterViewStatement.class;
    }
}

