/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.persist.metadata.service;

import com.google.common.base.Joiner;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.schema.swapper.YamlTableSwapper;
import org.apache.shardingsphere.mode.node.path.NodePath;
import org.apache.shardingsphere.mode.node.path.engine.generator.NodePathGenerator;
import org.apache.shardingsphere.mode.node.path.type.global.state.coordinator.CoordinatorType;
import org.apache.shardingsphere.mode.node.path.type.global.state.coordinator.table.TableCoordinatorTypeNodePath;
import org.apache.shardingsphere.mode.persist.service.TableMetaDataPersistService;
import org.apache.shardingsphere.mode.spi.repository.PersistRepository;

public final class TableMetaDataPersistDisabledService
implements TableMetaDataPersistService {
    private final PersistRepository repository;
    private final YamlTableSwapper swapper = new YamlTableSwapper();

    @Override
    public Collection<ShardingSphereTable> load(String databaseName, String schemaName) {
        return new LinkedList<ShardingSphereTable>();
    }

    @Override
    public Optional<ShardingSphereTable> load(String databaseName, String schemaName, String tableName) {
        return Optional.empty();
    }

    @Override
    public void persist(String databaseName, String schemaName, Collection<ShardingSphereTable> tables) {
        for (ShardingSphereTable each : tables) {
            TableCoordinatorTypeNodePath tableCoordinatorTypeNodePath = new TableCoordinatorTypeNodePath(Joiner.on((String)".").join((Object)databaseName, (Object)schemaName, new Object[]{each.getName()}), CoordinatorType.CREATE.name());
            this.repository.persist(NodePathGenerator.toPath((NodePath)tableCoordinatorTypeNodePath), YamlEngine.marshal((Object)this.swapper.swapToYamlConfiguration(each)));
            this.repository.delete(NodePathGenerator.toPath((NodePath)tableCoordinatorTypeNodePath.getTableCoordinatorPath()));
        }
    }

    @Override
    public void drop(String databaseName, String schemaName, String tableName) {
        TableCoordinatorTypeNodePath tableCoordinatorTypeNodePath = new TableCoordinatorTypeNodePath(Joiner.on((String)".").join((Object)databaseName, (Object)schemaName, new Object[]{tableName}), CoordinatorType.DROP.name());
        this.repository.persist(NodePathGenerator.toPath((NodePath)tableCoordinatorTypeNodePath), tableName);
        this.repository.delete(NodePathGenerator.toPath((NodePath)tableCoordinatorTypeNodePath.getTableCoordinatorPath()));
    }

    @Override
    public void drop(String databaseName, String schemaName, Collection<ShardingSphereTable> tables) {
        for (ShardingSphereTable each : tables) {
            this.drop(databaseName, schemaName, each.getName());
        }
    }

    @Generated
    public TableMetaDataPersistDisabledService(PersistRepository repository) {
        this.repository = repository;
    }
}

