/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.statistics.collector.postgresql.table;

import com.cedarsoftware.util.CaseInsensitiveMap;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.statistics.collector.postgresql.PostgreSQLTableStatisticsCollector;

public final class PostgreSQLPgClassTableStatisticsCollector
implements PostgreSQLTableStatisticsCollector {
    private static final String PUBLIC_SCHEMA = "public";

    @Override
    public Collection<Map<String, Object>> collect(String databaseName, String schemaName, String tableName, ShardingSphereMetaData metaData) {
        LinkedList<Map<String, Object>> result = new LinkedList<Map<String, Object>>();
        ShardingSphereSchema publicSchema = metaData.getDatabase(databaseName).getSchema(PUBLIC_SCHEMA);
        if (null != publicSchema) {
            for (ShardingSphereTable each : publicSchema.getAllTables()) {
                CaseInsensitiveMap columnValues = new CaseInsensitiveMap(4, 1.0f);
                columnValues.put("oid", 0L);
                columnValues.put("relnamespace", 0L);
                columnValues.put("relname", each.getName());
                columnValues.put("relkind", "r");
                result.add((Map<String, Object>)columnValues);
            }
        }
        return result;
    }

    @Override
    public String getSchemaName() {
        return "pg_catalog";
    }

    @Override
    public String getTableName() {
        return "pg_class";
    }

    public String getType() {
        return "pg_catalog.pg_class";
    }
}

