/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.hint;

import com.cedarsoftware.util.CaseInsensitiveMap;
import com.google.common.base.Splitter;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.hint.SQLHintPropertiesKey;
import org.apache.shardingsphere.infra.hint.SQLHintTokenType;

public final class SQLHintUtils {
    private static final String SQL_COMMENT_PREFIX = "/*";
    private static final String SQL_COMMENT_SUFFIX = "*/";
    private static final String SQL_HINT_SPLIT = ",";
    private static final String SQL_HINT_VALUE_SPLIT = "=";
    private static final String SQL_HINT_VALUE_COLLECTION_SPLIT = " ";
    private static final int SQL_HINT_VALUE_SIZE = 2;

    public static HintValueContext extractHint(String sql) {
        if (!SQLHintUtils.containsSQLHint(sql)) {
            return new HintValueContext();
        }
        HintValueContext result = new HintValueContext();
        int hintKeyValueBeginIndex = SQLHintUtils.getHintKeyValueBeginIndex(sql);
        String hintKeyValueText = sql.substring(hintKeyValueBeginIndex, sql.indexOf(SQL_COMMENT_SUFFIX, hintKeyValueBeginIndex));
        Map<String, String> hintKeyValues = SQLHintUtils.getSQLHintKeyValues(hintKeyValueText);
        if (SQLHintUtils.containsHintKey(hintKeyValues, SQLHintPropertiesKey.DATASOURCE_NAME_KEY)) {
            result.setDataSourceName(SQLHintUtils.getHintValue(hintKeyValues, SQLHintPropertiesKey.DATASOURCE_NAME_KEY));
        }
        if (SQLHintUtils.containsHintKey(hintKeyValues, SQLHintPropertiesKey.WRITE_ROUTE_ONLY_KEY)) {
            result.setWriteRouteOnly(Boolean.parseBoolean(SQLHintUtils.getHintValue(hintKeyValues, SQLHintPropertiesKey.WRITE_ROUTE_ONLY_KEY)));
        }
        if (SQLHintUtils.containsHintKey(hintKeyValues, SQLHintPropertiesKey.SKIP_SQL_REWRITE_KEY)) {
            result.setSkipSQLRewrite(Boolean.parseBoolean(SQLHintUtils.getHintValue(hintKeyValues, SQLHintPropertiesKey.SKIP_SQL_REWRITE_KEY)));
        }
        if (SQLHintUtils.containsHintKey(hintKeyValues, SQLHintPropertiesKey.SKIP_METADATA_VALIDATE_KEY)) {
            result.setSkipMetadataValidate(Boolean.parseBoolean(SQLHintUtils.getHintValue(hintKeyValues, SQLHintPropertiesKey.SKIP_METADATA_VALIDATE_KEY)));
        }
        if (SQLHintUtils.containsHintKey(hintKeyValues, SQLHintPropertiesKey.DISABLE_AUDIT_NAMES_KEY)) {
            String property = SQLHintUtils.getHintValue(hintKeyValues, SQLHintPropertiesKey.DISABLE_AUDIT_NAMES_KEY);
            result.getDisableAuditNames().addAll(SQLHintUtils.getSplitterSQLHintValue(property));
        }
        if (SQLHintUtils.containsHintKey(hintKeyValues, SQLHintPropertiesKey.SHADOW_KEY)) {
            result.setShadow(Boolean.parseBoolean(SQLHintUtils.getHintValue(hintKeyValues, SQLHintPropertiesKey.SHADOW_KEY)));
        }
        for (Map.Entry<String, String> entry : hintKeyValues.entrySet()) {
            Comparable<?> value = SQLHintUtils.convert(entry.getValue());
            if (SQLHintUtils.containsHintKey(Objects.toString(entry.getKey()), SQLHintPropertiesKey.SHARDING_DATABASE_VALUE_KEY)) {
                result.getShardingDatabaseValues().put((Object)Objects.toString(entry.getKey()).toUpperCase(), value);
            }
            if (!SQLHintUtils.containsHintKey(Objects.toString(entry.getKey()), SQLHintPropertiesKey.SHARDING_TABLE_VALUE_KEY)) continue;
            result.getShardingTableValues().put((Object)Objects.toString(entry.getKey()).toUpperCase(), value);
        }
        return result;
    }

    private static int getHintKeyValueBeginIndex(String sql) {
        int tokenBeginIndex = sql.contains(SQLHintTokenType.SQL_START_HINT_TOKEN.getKey()) ? sql.indexOf(SQLHintTokenType.SQL_START_HINT_TOKEN.getKey()) : sql.indexOf(SQLHintTokenType.SQL_START_HINT_TOKEN.getAlias());
        return sql.indexOf(":", tokenBeginIndex) + 1;
    }

    private static boolean containsSQLHint(String sql) {
        return (sql.contains(SQLHintTokenType.SQL_START_HINT_TOKEN.getKey()) || sql.contains(SQLHintTokenType.SQL_START_HINT_TOKEN.getAlias())) && sql.contains(SQL_COMMENT_PREFIX) && sql.contains(SQL_COMMENT_SUFFIX);
    }

    private static Map<String, String> getSQLHintKeyValues(String hintKeyValueText) {
        List sqlHints = Splitter.on((String)SQL_HINT_SPLIT).trimResults().splitToList((CharSequence)hintKeyValueText.trim());
        CaseInsensitiveMap result = new CaseInsensitiveMap(sqlHints.size(), 1.0f);
        for (String each : sqlHints) {
            List hintValues = Splitter.on((String)SQL_HINT_VALUE_SPLIT).trimResults().splitToList((CharSequence)each);
            if (2 != hintValues.size()) continue;
            result.put((String)hintValues.get(0), (String)hintValues.get(1));
        }
        return result;
    }

    private static Comparable<?> convert(String value) {
        try {
            return new BigInteger(value);
        }
        catch (NumberFormatException ignored) {
            return value;
        }
    }

    private static boolean containsHintKey(Map<String, String> hintKeyValues, SQLHintPropertiesKey sqlHintPropsKey) {
        return hintKeyValues.containsKey(sqlHintPropsKey.getKey()) || hintKeyValues.containsKey(sqlHintPropsKey.getAlias());
    }

    private static boolean containsHintKey(String hintPropKey, SQLHintPropertiesKey sqlHintPropsKey) {
        return hintPropKey.contains(sqlHintPropsKey.getKey()) || hintPropKey.contains(sqlHintPropsKey.getAlias());
    }

    private static String getHintValue(Map<String, String> hintKeyValues, SQLHintPropertiesKey sqlHintPropsKey) {
        String result = hintKeyValues.get(sqlHintPropsKey.getKey());
        return null == result ? hintKeyValues.get(sqlHintPropsKey.getAlias()) : result;
    }

    private static Collection<String> getSplitterSQLHintValue(String property) {
        return property.isEmpty() ? Collections.emptySet() : new HashSet(Splitter.on((String)SQL_HINT_VALUE_COLLECTION_SPLIT).omitEmptyStrings().trimResults().splitToList((CharSequence)property));
    }

    public static String removeHint(String sql) {
        if (SQLHintUtils.containsSQLHint(sql)) {
            int hintKeyValueBeginIndex = SQLHintUtils.getHintKeyValueBeginIndex(sql);
            int sqlHintBeginIndex = sql.substring(0, hintKeyValueBeginIndex).lastIndexOf(SQL_COMMENT_PREFIX, hintKeyValueBeginIndex);
            int sqlHintEndIndex = sql.indexOf(SQL_COMMENT_SUFFIX, hintKeyValueBeginIndex) + SQL_COMMENT_SUFFIX.length();
            String removedHintSQL = sql.substring(0, sqlHintBeginIndex) + sql.substring(sqlHintEndIndex);
            return removedHintSQL.trim();
        }
        return sql;
    }

    @Generated
    private SQLHintUtils() {
    }
}

