/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.database;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.jdbcurl.DialectJdbcUrlFetcher;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeFactory;
import org.apache.shardingsphere.infra.config.database.DatabaseConfiguration;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.exception.external.sql.type.wrapper.SQLWrapperException;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;

public final class DatabaseTypeEngine {
    private static final String DEFAULT_DATABASE_TYPE = "MySQL";

    public static DatabaseType getProtocolType(DatabaseConfiguration databaseConfig, ConfigurationProperties props) {
        return DatabaseTypeEngine.getDatabaseType(DatabaseTypeEngine.getDataSources(databaseConfig), props);
    }

    public static DatabaseType getProtocolType(Map<String, DatabaseConfiguration> databaseConfigs, ConfigurationProperties props) {
        return DatabaseTypeEngine.getDatabaseType(DatabaseTypeEngine.getDataSources(databaseConfigs), props);
    }

    private static DatabaseType getDatabaseType(Map<String, DataSource> dataSources, ConfigurationProperties props) {
        return DatabaseTypeEngine.findConfiguredDatabaseType(props).orElseGet(() -> dataSources.isEmpty() ? DatabaseTypeEngine.getDefaultStorageType() : DatabaseTypeEngine.getStorageType((DataSource)dataSources.values().iterator().next()));
    }

    private static Optional<DatabaseType> findConfiguredDatabaseType(ConfigurationProperties props) {
        DatabaseType configuredDatabaseType = (DatabaseType)props.getValue(ConfigurationPropertyKey.PROXY_FRONTEND_DATABASE_PROTOCOL_TYPE);
        return null == configuredDatabaseType ? Optional.empty() : Optional.of(configuredDatabaseType.getTrunkDatabaseType().orElse(configuredDatabaseType));
    }

    private static Map<String, DataSource> getDataSources(Map<String, DatabaseConfiguration> databaseConfigs) {
        LinkedHashMap<String, DataSource> result = new LinkedHashMap<String, DataSource>();
        for (Map.Entry<String, DatabaseConfiguration> entry : databaseConfigs.entrySet()) {
            result.putAll(DatabaseTypeEngine.getDataSources(entry.getValue()));
        }
        return result;
    }

    private static Map<String, DataSource> getDataSources(DatabaseConfiguration databaseConfig) {
        return databaseConfig.getStorageUnits().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((StorageUnit)entry.getValue()).getDataSource(), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    public static DatabaseType getStorageType(DataSource dataSource) {
        DatabaseType databaseType;
        block9: {
            Connection connection = dataSource.getConnection();
            try {
                databaseType = DatabaseTypeFactory.get((String)connection.getMetaData().getURL());
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLFeatureNotSupportedException sqlFeatureNotSupportedException) {
                    return DatabaseTypeEngine.findStorageType(dataSource).orElseThrow(() -> new SQLWrapperException((SQLException)sqlFeatureNotSupportedException));
                }
                catch (SQLException ex) {
                    throw new SQLWrapperException(ex);
                }
            }
            connection.close();
        }
        return databaseType;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Optional<DatabaseType> findStorageType(DataSource dataSource) {
        try (Connection connection = dataSource.getConnection();){
            DialectJdbcUrlFetcher each;
            Iterator iterator = ShardingSphereServiceLoader.getServiceInstances(DialectJdbcUrlFetcher.class).iterator();
            do {
                if (!iterator.hasNext()) return Optional.empty();
            } while (!connection.isWrapperFor((each = (DialectJdbcUrlFetcher)iterator.next()).getConnectionClass()));
            Optional<DatabaseType> optional = Optional.of(DatabaseTypeFactory.get((String)each.fetch(connection)));
            return optional;
        }
        catch (SQLException ex) {
            throw new SQLWrapperException(ex);
        }
    }

    public static DatabaseType getDefaultStorageType() {
        return (DatabaseType)TypedSPILoader.getService(DatabaseType.class, (Object)DEFAULT_DATABASE_TYPE);
    }

    @Generated
    private DatabaseTypeEngine() {
    }
}

