/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.compiler.sql.ast.converter.statement.type;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.SqlUpdate;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.assignment.ColumnAssignmentSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.assignment.SetAssignmentSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.pagination.limit.LimitSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.UpdateStatement;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;
import org.apache.shardingsphere.sqlfederation.compiler.sql.ast.converter.segment.expression.ExpressionConverter;
import org.apache.shardingsphere.sqlfederation.compiler.sql.ast.converter.segment.expression.impl.ColumnConverter;
import org.apache.shardingsphere.sqlfederation.compiler.sql.ast.converter.segment.from.TableConverter;
import org.apache.shardingsphere.sqlfederation.compiler.sql.ast.converter.segment.limit.PaginationValueSQLConverter;
import org.apache.shardingsphere.sqlfederation.compiler.sql.ast.converter.segment.orderby.OrderByConverter;
import org.apache.shardingsphere.sqlfederation.compiler.sql.ast.converter.segment.where.WhereConverter;
import org.apache.shardingsphere.sqlfederation.compiler.sql.ast.converter.statement.SQLStatementConverter;

public final class UpdateStatementConverter
implements SQLStatementConverter<UpdateStatement, SqlNode> {
    @Override
    public SqlNode convert(UpdateStatement updateStatement) {
        SqlUpdate sqlUpdate = this.convertUpdate(updateStatement);
        SqlNodeList orderBy = updateStatement.getOrderBy().flatMap(OrderByConverter::convert).orElse(SqlNodeList.EMPTY);
        Optional limit = updateStatement.getLimit();
        if (limit.isPresent()) {
            SqlNode offset = ((LimitSegment)limit.get()).getOffset().flatMap(PaginationValueSQLConverter::convert).orElse(null);
            SqlNode rowCount = ((LimitSegment)limit.get()).getRowCount().flatMap(PaginationValueSQLConverter::convert).orElse(null);
            return new SqlOrderBy(SqlParserPos.ZERO, (SqlNode)sqlUpdate, orderBy, offset, rowCount);
        }
        return orderBy.isEmpty() ? sqlUpdate : new SqlOrderBy(SqlParserPos.ZERO, (SqlNode)sqlUpdate, orderBy, null, null);
    }

    private SqlUpdate convertUpdate(UpdateStatement updateStatement) {
        SqlNode table = TableConverter.convert(updateStatement.getTable()).orElseThrow(IllegalStateException::new);
        SqlIdentifier alias = this.convertTableAlias(updateStatement);
        SqlNode condition = updateStatement.getWhere().flatMap(WhereConverter::convert).orElse(null);
        SqlNodeList columns = new SqlNodeList(SqlParserPos.ZERO);
        SqlNodeList expressions = new SqlNodeList(SqlParserPos.ZERO);
        for (ColumnAssignmentSegment each : ((SetAssignmentSegment)updateStatement.getAssignment().orElseThrow(IllegalStateException::new)).getAssignments()) {
            columns.addAll((Collection)each.getColumns().stream().map(ColumnConverter::convert).collect(Collectors.toList()));
            expressions.add(ExpressionConverter.convert(each.getValue()).orElseThrow(IllegalStateException::new));
        }
        return new SqlUpdate(SqlParserPos.ZERO, this.getTargetTableName(table), columns, expressions, condition, null, alias);
    }

    private SqlIdentifier convertTableAlias(UpdateStatement updateStatement) {
        if (updateStatement.getTable().getAlias().isPresent()) {
            IdentifierValue aliasIdentifier = (IdentifierValue)updateStatement.getTable().getAlias().get();
            return new SqlIdentifier(aliasIdentifier.getValue(), SqlParserPos.ZERO);
        }
        return null;
    }

    private SqlNode getTargetTableName(SqlNode deleteTable) {
        return deleteTable instanceof SqlBasicCall ? (SqlNode)((SqlBasicCall)deleteTable).getOperandList().iterator().next() : deleteTable;
    }
}

