/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.state;

import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.View;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.data.PointData;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorFactory;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarFilterInternal;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.export.RegisteredReader;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.state.DefaultSynchronousMetricStorage;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.state.EmptyMetricStorage;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.state.MetricStorage;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.view.RegisteredView;

public interface SynchronousMetricStorage
extends MetricStorage,
WriteableMetricStorage {
    public static SynchronousMetricStorage empty() {
        return EmptyMetricStorage.INSTANCE;
    }

    public static <T extends PointData> SynchronousMetricStorage create(RegisteredReader registeredReader, RegisteredView registeredView, InstrumentDescriptor instrumentDescriptor, ExemplarFilterInternal exemplarFilter, boolean enabled) {
        View view = registeredView.getView();
        MetricDescriptor metricDescriptor = MetricDescriptor.create(view, registeredView.getViewSourceInfo(), instrumentDescriptor);
        Aggregator aggregator = ((AggregatorFactory)((Object)view.getAggregation())).createAggregator(instrumentDescriptor, exemplarFilter, registeredReader.getReader().getMemoryMode());
        if (Aggregator.drop() == aggregator) {
            return SynchronousMetricStorage.empty();
        }
        return new DefaultSynchronousMetricStorage(registeredReader, metricDescriptor, aggregator, registeredView.getViewAttributesProcessor(), registeredView.getCardinalityLimit(), enabled);
    }
}

