/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.util;

import com.alipay.sofa.jraft.Closure;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.util.NamedThreadFactory;
import com.alipay.sofa.jraft.util.OnlyForTest;
import com.alipay.sofa.jraft.util.ThreadPoolUtil;
import com.alipay.sofa.jraft.util.Utils;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolsFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadPoolsFactory.class);
    private static final ConcurrentMap<String, ThreadPoolExecutor> GROUP_THREAD_POOLS = new ConcurrentHashMap<String, ThreadPoolExecutor>();

    public static void registerThreadPool(String groupId, ThreadPoolExecutor executor) {
        if (executor == null) {
            throw new IllegalArgumentException("executor must not be null");
        }
        if (GROUP_THREAD_POOLS.putIfAbsent(groupId, executor) != null) {
            throw new IllegalArgumentException(String.format("The group: %s has already registered the ThreadPool", groupId));
        }
    }

    @OnlyForTest
    protected static ThreadPoolExecutor getExecutor(String groupId) {
        return GROUP_THREAD_POOLS.getOrDefault(groupId, GlobalThreadPoolHolder.INSTANCE);
    }

    public static Future<?> runInThread(String groupId, Runnable runnable) {
        return GROUP_THREAD_POOLS.getOrDefault(groupId, GlobalThreadPoolHolder.INSTANCE).submit(runnable);
    }

    public static Future<?> runClosureInThread(String groupId, Closure done, Status status) {
        if (done == null) {
            return null;
        }
        return ThreadPoolsFactory.runInThread(groupId, () -> {
            try {
                done.run(status);
            }
            catch (Throwable t) {
                LOG.error("Fail to run done closure", t);
            }
        });
    }

    public static Future<?> runClosureInThread(String groupId, Closure done) {
        if (done == null) {
            return null;
        }
        return ThreadPoolsFactory.runClosureInThread(groupId, done, Status.OK());
    }

    private static class GlobalThreadPoolHolder {
        private static final ThreadPoolExecutor INSTANCE = ThreadPoolUtil.newBuilder().poolName("JRAFT_GROUP_DEFAULT_EXECUTOR").enableMetric(true).coreThreads(Utils.MIN_CLOSURE_EXECUTOR_POOL_SIZE).maximumThreads(Utils.MAX_CLOSURE_EXECUTOR_POOL_SIZE).keepAliveSeconds(60L).workQueue(new SynchronousQueue<Runnable>()).threadFactory(new NamedThreadFactory("JRaft-Group-Default-Executor-", true)).build();

        private GlobalThreadPoolHolder() {
        }
    }
}

