/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.grpc.v2.consumer;

import apache.rocketmq.v2.ChangeInvisibleDurationRequest;
import apache.rocketmq.v2.ChangeInvisibleDurationResponse;
import apache.rocketmq.v2.Code;
import com.google.protobuf.Duration;
import com.google.protobuf.util.Durations;
import io.netty.channel.Channel;
import java.util.concurrent.CompletableFuture;
import org.apache.rocketmq.client.consumer.AckResult;
import org.apache.rocketmq.client.consumer.AckStatus;
import org.apache.rocketmq.common.consumer.ReceiptHandle;
import org.apache.rocketmq.proxy.common.MessageReceiptHandle;
import org.apache.rocketmq.proxy.common.ProxyContext;
import org.apache.rocketmq.proxy.grpc.v2.AbstractMessagingActivity;
import org.apache.rocketmq.proxy.grpc.v2.channel.GrpcChannelManager;
import org.apache.rocketmq.proxy.grpc.v2.common.GrpcClientSettingsManager;
import org.apache.rocketmq.proxy.grpc.v2.common.ResponseBuilder;
import org.apache.rocketmq.proxy.processor.MessagingProcessor;

public class ChangeInvisibleDurationActivity
extends AbstractMessagingActivity {
    public ChangeInvisibleDurationActivity(MessagingProcessor messagingProcessor, GrpcClientSettingsManager grpcClientSettingsManager, GrpcChannelManager grpcChannelManager) {
        super(messagingProcessor, grpcClientSettingsManager, grpcChannelManager);
    }

    public CompletableFuture<ChangeInvisibleDurationResponse> changeInvisibleDuration(ProxyContext ctx, ChangeInvisibleDurationRequest request) {
        CompletableFuture<ChangeInvisibleDurationResponse> future = new CompletableFuture<ChangeInvisibleDurationResponse>();
        try {
            this.validateTopicAndConsumerGroup(request.getTopic(), request.getGroup());
            this.validateInvisibleTime(Durations.toMillis((Duration)request.getInvisibleDuration()));
            ReceiptHandle receiptHandle = ReceiptHandle.decode((String)request.getReceiptHandle());
            String group = request.getGroup().getName();
            MessageReceiptHandle messageReceiptHandle = this.messagingProcessor.removeReceiptHandle(ctx, (Channel)this.grpcChannelManager.getChannel(ctx.getClientID()), group, request.getMessageId(), receiptHandle.getReceiptHandle());
            if (messageReceiptHandle != null) {
                receiptHandle = ReceiptHandle.decode((String)messageReceiptHandle.getReceiptHandleStr());
            }
            return this.messagingProcessor.changeInvisibleTime(ctx, receiptHandle, request.getMessageId(), group, request.getTopic().getName(), Durations.toMillis((Duration)request.getInvisibleDuration())).thenApply(ackResult -> this.convertToChangeInvisibleDurationResponse(ctx, request, (AckResult)ackResult));
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
            return future;
        }
    }

    protected ChangeInvisibleDurationResponse convertToChangeInvisibleDurationResponse(ProxyContext ctx, ChangeInvisibleDurationRequest request, AckResult ackResult) {
        if (AckStatus.OK.equals((Object)ackResult.getStatus())) {
            return ChangeInvisibleDurationResponse.newBuilder().setStatus(ResponseBuilder.getInstance().buildStatus(Code.OK, Code.OK.name())).setReceiptHandle(ackResult.getExtraInfo()).build();
        }
        return ChangeInvisibleDurationResponse.newBuilder().setStatus(ResponseBuilder.getInstance().buildStatus(Code.INTERNAL_SERVER_ERROR, "changeInvisibleDuration failed: status is abnormal")).build();
    }
}

