/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.storage.dledger.store.file;

import io.netty.util.internal.StringUtil;
import io.openmessaging.storage.dledger.DLedgerConfig;
import io.openmessaging.storage.dledger.store.file.MmapFile;
import io.openmessaging.storage.dledger.store.file.MmapFileList;
import io.openmessaging.storage.dledger.utils.DLedgerUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;

public class MultiPathMmapFileList
extends MmapFileList {
    private final Supplier<Set<String>> fullStorePathsSupplier;
    private final DLedgerConfig config;

    public MultiPathMmapFileList(DLedgerConfig config, int mappedFileSize, Supplier<Set<String>> fullStorePathsSupplier) {
        super(config.getDataStorePath(), mappedFileSize);
        this.config = config;
        this.fullStorePathsSupplier = fullStorePathsSupplier;
    }

    private Set<String> getPaths() {
        String[] paths = this.config.getDataStorePath().trim().split(DLedgerConfig.MULTI_PATH_SPLITTER);
        return new HashSet<String>(Arrays.asList(paths));
    }

    private Set<String> getReadonlyPaths() {
        String pathStr = this.config.getReadOnlyDataStoreDirs();
        if (StringUtil.isNullOrEmpty((String)pathStr)) {
            return Collections.emptySet();
        }
        String[] paths = pathStr.trim().split(DLedgerConfig.MULTI_PATH_SPLITTER);
        return new HashSet<String>(Arrays.asList(paths));
    }

    @Override
    public boolean load() {
        Set<String> storePathSet = this.getPaths();
        storePathSet.addAll(this.getReadonlyPaths());
        ArrayList<File> files = new ArrayList<File>();
        for (String path : storePathSet) {
            File dir = new File(path);
            File[] ls = dir.listFiles();
            if (ls == null) continue;
            Collections.addAll(files, ls);
        }
        return this.doLoad(files);
    }

    @Override
    protected MmapFile tryCreateMappedFile(long createOffset) {
        long fileIdx = createOffset / (long)this.getMappedFileSize();
        Set<String> storePath = this.getPaths();
        Set<String> readonlyPathSet = this.getReadonlyPaths();
        Set fullStorePaths = this.fullStorePathsSupplier == null ? Collections.emptySet() : this.fullStorePathsSupplier.get();
        HashSet<String> availableStorePath = new HashSet<String>(storePath);
        availableStorePath.removeAll(readonlyPathSet);
        availableStorePath.removeAll(fullStorePaths);
        if (availableStorePath.isEmpty()) {
            availableStorePath = new HashSet<String>(storePath);
            availableStorePath.removeAll(readonlyPathSet);
        }
        Object[] paths = availableStorePath.toArray(new String[0]);
        Arrays.sort(paths);
        String nextFilePath = (String)paths[(int)(fileIdx % (long)paths.length)] + File.separator + DLedgerUtils.offset2FileName(createOffset);
        return this.doCreateMappedFile(nextFilePath);
    }

    @Override
    public void destroy() {
        for (MmapFile mf : this.getMappedFiles()) {
            mf.destroy(3000L);
        }
        this.getMappedFiles().clear();
        this.setFlushedWhere(0L);
        Set<String> storePathSet = this.getPaths();
        storePathSet.addAll(this.getReadonlyPaths());
        for (String path : storePathSet) {
            File file = new File(path);
            if (!file.isDirectory()) continue;
            file.delete();
        }
    }
}

