/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.sql.SqlEncryptionProtector;
import com.microsoft.azure.management.sql.SqlEncryptionProtectorOperations;
import com.microsoft.azure.management.sql.SqlServer;
import com.microsoft.azure.management.sql.implementation.EncryptionProtectorInner;
import com.microsoft.azure.management.sql.implementation.SqlEncryptionProtectorImpl;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
public class SqlEncryptionProtectorOperationsImpl
implements SqlEncryptionProtectorOperations,
SqlEncryptionProtectorOperations.SqlEncryptionProtectorActionsDefinition {
    protected SqlServerManager sqlServerManager;
    protected SqlServer sqlServer;

    SqlEncryptionProtectorOperationsImpl(SqlServer parent, SqlServerManager sqlServerManager) {
        Objects.requireNonNull(sqlServerManager);
        Objects.requireNonNull(parent);
        this.sqlServer = parent;
        this.sqlServerManager = sqlServerManager;
    }

    SqlEncryptionProtectorOperationsImpl(SqlServerManager sqlServerManager) {
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
    }

    @Override
    public SqlEncryptionProtector getBySqlServer(String resourceGroupName, String sqlServerName) {
        EncryptionProtectorInner encryptionProtectorInner = ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).encryptionProtectors().get(resourceGroupName, sqlServerName);
        return encryptionProtectorInner != null ? new SqlEncryptionProtectorImpl(resourceGroupName, sqlServerName, encryptionProtectorInner, this.sqlServerManager) : null;
    }

    @Override
    public Observable<SqlEncryptionProtector> getBySqlServerAsync(final String resourceGroupName, final String sqlServerName) {
        final SqlEncryptionProtectorOperationsImpl self = this;
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).encryptionProtectors().getAsync(resourceGroupName, sqlServerName).map((Func1)new Func1<EncryptionProtectorInner, SqlEncryptionProtector>(){

            public SqlEncryptionProtector call(EncryptionProtectorInner encryptionProtectorInner) {
                return new SqlEncryptionProtectorImpl(resourceGroupName, sqlServerName, encryptionProtectorInner, self.sqlServerManager);
            }
        });
    }

    @Override
    public SqlEncryptionProtector getBySqlServer(SqlServer sqlServer) {
        Objects.requireNonNull(sqlServer);
        EncryptionProtectorInner encryptionProtectorInner = ((SqlManagementClientImpl)((Object)((SqlServerManager)((Object)sqlServer.manager())).inner())).encryptionProtectors().get(sqlServer.resourceGroupName(), sqlServer.name());
        return encryptionProtectorInner != null ? new SqlEncryptionProtectorImpl((SqlServerImpl)sqlServer, encryptionProtectorInner, (SqlServerManager)((Object)sqlServer.manager())) : null;
    }

    @Override
    public Observable<SqlEncryptionProtector> getBySqlServerAsync(final SqlServer sqlServer) {
        Objects.requireNonNull(sqlServer);
        return ((SqlManagementClientImpl)((Object)((SqlServerManager)((Object)sqlServer.manager())).inner())).encryptionProtectors().getAsync(sqlServer.resourceGroupName(), sqlServer.name()).map((Func1)new Func1<EncryptionProtectorInner, SqlEncryptionProtector>(){

            public SqlEncryptionProtector call(EncryptionProtectorInner encryptionProtectorInner) {
                return new SqlEncryptionProtectorImpl((SqlServerImpl)sqlServer, encryptionProtectorInner, (SqlServerManager)((Object)sqlServer.manager()));
            }
        });
    }

    @Override
    public SqlEncryptionProtector get() {
        if (this.sqlServer == null) {
            return null;
        }
        return this.getBySqlServer(this.sqlServer);
    }

    @Override
    public Observable<SqlEncryptionProtector> getAsync() {
        if (this.sqlServer == null) {
            return null;
        }
        return this.getBySqlServerAsync(this.sqlServer);
    }

    @Override
    public SqlEncryptionProtector getById(String id) {
        Objects.requireNonNull(id);
        return this.getBySqlServer(ResourceUtils.groupFromResourceId((String)id), ResourceUtils.nameFromResourceId((String)ResourceUtils.parentRelativePathFromResourceId((String)id)));
    }

    @Override
    public Observable<SqlEncryptionProtector> getByIdAsync(String id) {
        Objects.requireNonNull(id);
        return this.getBySqlServerAsync(ResourceUtils.groupFromResourceId((String)id), ResourceUtils.nameFromResourceId((String)ResourceUtils.parentRelativePathFromResourceId((String)id)));
    }

    @Override
    public List<SqlEncryptionProtector> list() {
        if (this.sqlServer == null) {
            return null;
        }
        return this.listBySqlServer(this.sqlServer);
    }

    @Override
    public Observable<SqlEncryptionProtector> listAsync() {
        if (this.sqlServer == null) {
            return null;
        }
        return this.listBySqlServerAsync(this.sqlServer);
    }

    @Override
    public List<SqlEncryptionProtector> listBySqlServer(String resourceGroupName, String sqlServerName) {
        ArrayList<SqlEncryptionProtectorImpl> encryptionProtectors = new ArrayList<SqlEncryptionProtectorImpl>();
        PagedList<EncryptionProtectorInner> encryptionProtectorInners = ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).encryptionProtectors().listByServer(resourceGroupName, sqlServerName);
        if (encryptionProtectorInners != null) {
            for (EncryptionProtectorInner inner : encryptionProtectorInners) {
                encryptionProtectors.add(new SqlEncryptionProtectorImpl(resourceGroupName, sqlServerName, inner, this.sqlServerManager));
            }
        }
        return Collections.unmodifiableList(encryptionProtectors);
    }

    @Override
    public Observable<SqlEncryptionProtector> listBySqlServerAsync(final String resourceGroupName, final String sqlServerName) {
        final SqlEncryptionProtectorOperationsImpl self = this;
        return ((SqlManagementClientImpl)((Object)this.sqlServerManager.inner())).encryptionProtectors().listByServerAsync(resourceGroupName, sqlServerName).flatMap((Func1)new Func1<Page<EncryptionProtectorInner>, Observable<EncryptionProtectorInner>>(){

            public Observable<EncryptionProtectorInner> call(Page<EncryptionProtectorInner> encryptionProtectorInnerPage) {
                return Observable.from((Iterable)encryptionProtectorInnerPage.items());
            }
        }).map((Func1)new Func1<EncryptionProtectorInner, SqlEncryptionProtector>(){

            public SqlEncryptionProtector call(EncryptionProtectorInner encryptionProtectorInner) {
                return new SqlEncryptionProtectorImpl(resourceGroupName, sqlServerName, encryptionProtectorInner, self.sqlServerManager);
            }
        });
    }

    @Override
    public List<SqlEncryptionProtector> listBySqlServer(SqlServer sqlServer) {
        Objects.requireNonNull(sqlServer);
        ArrayList<SqlEncryptionProtectorImpl> encryptionProtectors = new ArrayList<SqlEncryptionProtectorImpl>();
        PagedList<EncryptionProtectorInner> encryptionProtectorInners = ((SqlManagementClientImpl)((Object)((SqlServerManager)((Object)sqlServer.manager())).inner())).encryptionProtectors().listByServer(sqlServer.resourceGroupName(), sqlServer.name());
        if (encryptionProtectorInners != null) {
            for (EncryptionProtectorInner inner : encryptionProtectorInners) {
                encryptionProtectors.add(new SqlEncryptionProtectorImpl((SqlServerImpl)sqlServer, inner, (SqlServerManager)((Object)sqlServer.manager())));
            }
        }
        return Collections.unmodifiableList(encryptionProtectors);
    }

    @Override
    public Observable<SqlEncryptionProtector> listBySqlServerAsync(final SqlServer sqlServer) {
        Objects.requireNonNull(sqlServer);
        return ((SqlManagementClientImpl)((Object)((SqlServerManager)((Object)sqlServer.manager())).inner())).encryptionProtectors().listByServerAsync(sqlServer.resourceGroupName(), sqlServer.name()).flatMap((Func1)new Func1<Page<EncryptionProtectorInner>, Observable<EncryptionProtectorInner>>(){

            public Observable<EncryptionProtectorInner> call(Page<EncryptionProtectorInner> encryptionProtectorInnerPage) {
                return Observable.from((Iterable)encryptionProtectorInnerPage.items());
            }
        }).map((Func1)new Func1<EncryptionProtectorInner, SqlEncryptionProtector>(){

            public SqlEncryptionProtector call(EncryptionProtectorInner encryptionProtectorInner) {
                return new SqlEncryptionProtectorImpl((SqlServerImpl)sqlServer, encryptionProtectorInner, (SqlServerManager)((Object)sqlServer.manager()));
            }
        });
    }
}

