/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.client.core.PageParams;
import org.elasticsearch.client.ml.job.config.Job;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class GetModelSnapshotsRequest
extends ActionRequest
implements ToXContentObject {
    public static final ParseField SNAPSHOT_ID = new ParseField("snapshot_id", new String[0]);
    public static final ParseField SORT = new ParseField("sort", new String[0]);
    public static final ParseField START = new ParseField("start", new String[0]);
    public static final ParseField END = new ParseField("end", new String[0]);
    public static final ParseField DESC = new ParseField("desc", new String[0]);
    public static final ConstructingObjectParser<GetModelSnapshotsRequest, Void> PARSER = new ConstructingObjectParser("get_model_snapshots_request", a -> new GetModelSnapshotsRequest((String)a[0]));
    private final String jobId;
    private String snapshotId;
    private String sort;
    private String start;
    private String end;
    private Boolean desc;
    private PageParams pageParams;

    public GetModelSnapshotsRequest(String jobId) {
        this.jobId = Objects.requireNonNull(jobId);
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public void setSnapshotId(String snapshotId) {
        this.snapshotId = snapshotId;
    }

    public String getSort() {
        return this.sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public PageParams getPageParams() {
        return this.pageParams;
    }

    public void setPageParams(PageParams pageParams) {
        this.pageParams = pageParams;
    }

    public String getStart() {
        return this.start;
    }

    public void setStart(String start) {
        this.start = start;
    }

    public String getEnd() {
        return this.end;
    }

    public void setEnd(String end) {
        this.end = end;
    }

    public Boolean getDesc() {
        return this.desc;
    }

    public void setDesc(boolean desc) {
        this.desc = desc;
    }

    public ActionRequestValidationException validate() {
        return null;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Job.ID.getPreferredName(), this.jobId);
        if (this.snapshotId != null) {
            builder.field(SNAPSHOT_ID.getPreferredName(), this.snapshotId);
        }
        if (this.sort != null) {
            builder.field(SORT.getPreferredName(), this.sort);
        }
        if (this.start != null) {
            builder.field(START.getPreferredName(), this.start);
        }
        if (this.end != null) {
            builder.field(END.getPreferredName(), this.end);
        }
        if (this.desc != null) {
            builder.field(DESC.getPreferredName(), this.desc);
        }
        if (this.pageParams != null) {
            builder.field(PageParams.PAGE.getPreferredName(), (ToXContent)this.pageParams);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        GetModelSnapshotsRequest request = (GetModelSnapshotsRequest)((Object)obj);
        return Objects.equals(this.jobId, request.jobId) && Objects.equals(this.snapshotId, request.snapshotId) && Objects.equals(this.sort, request.sort) && Objects.equals(this.start, request.start) && Objects.equals(this.end, request.end) && Objects.equals(this.desc, request.desc) && Objects.equals(this.pageParams, request.pageParams);
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.snapshotId, this.pageParams, this.start, this.end, this.sort, this.desc);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), Job.ID);
        PARSER.declareString(GetModelSnapshotsRequest::setSnapshotId, SNAPSHOT_ID);
        PARSER.declareString(GetModelSnapshotsRequest::setSort, SORT);
        PARSER.declareStringOrNull(GetModelSnapshotsRequest::setStart, START);
        PARSER.declareStringOrNull(GetModelSnapshotsRequest::setEnd, END);
        PARSER.declareBoolean(GetModelSnapshotsRequest::setDesc, DESC);
        PARSER.declareObject(GetModelSnapshotsRequest::setPageParams, PageParams.PARSER, PageParams.PAGE);
    }
}

