/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.server.tomcat;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.ranger.plugin.util.XMLUtils;

public class EmbeddedServerUtil {
    private static final Logger LOG = Logger.getLogger(EmbeddedServerUtil.class.getName());
    private static final String CONFIG_FILE = "ranger-admin-site.xml";
    private static final String CORE_SITE_CONFIG_FILENAME = "core-site.xml";
    private static final String DEFAULT_CONFIG_FILENAME = "ranger-admin-default-site.xml";
    private static Properties rangerConfigProperties = new Properties();

    private EmbeddedServerUtil() {
        EmbeddedServerUtil.loadRangerConfigProperties(CONFIG_FILE);
    }

    public static void loadRangerConfigProperties(String configFile) {
        if (CONFIG_FILE.equalsIgnoreCase(configFile)) {
            XMLUtils.loadConfig((String)DEFAULT_CONFIG_FILENAME, (Map)rangerConfigProperties);
        }
        XMLUtils.loadConfig((String)CORE_SITE_CONFIG_FILENAME, (Map)rangerConfigProperties);
        XMLUtils.loadConfig((String)configFile, (Map)rangerConfigProperties);
    }

    public static Properties getRangerConfigProperties() {
        if (rangerConfigProperties.isEmpty()) {
            EmbeddedServerUtil.loadRangerConfigProperties(CONFIG_FILE);
        }
        return rangerConfigProperties;
    }

    public static String getConfig(String key, String defaultValue) {
        String ret = EmbeddedServerUtil.getConfig(key);
        if (ret == null) {
            ret = defaultValue;
        }
        return ret;
    }

    public static boolean getBooleanConfig(String key, boolean defaultValue) {
        boolean ret = defaultValue;
        String retStr = EmbeddedServerUtil.getConfig(key);
        try {
            if (retStr != null) {
                ret = Boolean.parseBoolean(retStr);
            }
        }
        catch (Exception err) {
            LOG.severe(retStr + " can't be parsed to int. Reason: " + err.toString());
        }
        return ret;
    }

    public static int getIntConfig(String key, int defaultValue) {
        int ret = defaultValue;
        String retStr = EmbeddedServerUtil.getConfig(key);
        try {
            if (retStr != null) {
                ret = Integer.parseInt(retStr);
            }
        }
        catch (Exception err) {
            LOG.severe(retStr + " can't be parsed to int. Reason: " + err.toString());
        }
        return ret;
    }

    public static Long getLongConfig(String key, Long defaultValue) {
        Long ret = defaultValue;
        String retStr = EmbeddedServerUtil.getConfig(key);
        try {
            if (retStr != null) {
                ret = Long.parseLong(retStr);
            }
        }
        catch (Exception err) {
            LOG.severe(retStr + " can't be parsed to long. Reason: " + err.toString());
        }
        return ret;
    }

    public static String getConfig(String key) {
        String value = EmbeddedServerUtil.getRangerConfigProperties().getProperty(key);
        if (value == null || value.trim().isEmpty()) {
            value = System.getProperty(key);
        }
        return value;
    }

    public static String getHosts(String urls) {
        if (urls != null && "NONE".equalsIgnoreCase(urls = urls.trim())) {
            urls = null;
        }
        return urls;
    }

    public static List<String> toArray(String destListStr, String delim) {
        ArrayList<String> list = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)destListStr)) {
            StringTokenizer tokenizer = new StringTokenizer(destListStr, delim.trim());
            while (tokenizer.hasMoreTokens()) {
                list.add(tokenizer.nextToken());
            }
        }
        return list;
    }
}

