/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.nifi.registry.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.client.urlconnection.HTTPSProperties;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ranger.plugin.client.BaseClient;
import org.apache.ranger.plugin.service.ResourceLookupContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NiFiRegistryClient {
    private static final Logger LOG = LoggerFactory.getLogger(NiFiRegistryClient.class);
    static final String SUCCESS_MSG = "ConnectionTest Successful";
    static final String FAILURE_MSG = "Unable to retrieve any resources using given parameters. ";
    private final String url;
    private final SSLContext sslContext;
    private final HostnameVerifier hostnameVerifier;
    private final ObjectMapper mapper = new ObjectMapper();

    public NiFiRegistryClient(String url, SSLContext sslContext) {
        this.url = url;
        this.sslContext = sslContext;
        this.hostnameVerifier = new NiFiRegistryHostnameVerifier();
    }

    public HashMap<String, Object> connectionTest() {
        boolean connectivityStatus;
        String errMsg = "";
        HashMap<String, Object> responseData = new HashMap<String, Object>();
        try {
            WebResource resource = this.getWebResource();
            ClientResponse response = this.getResponse(resource, "application/json");
            if (LOG.isDebugEnabled()) {
                LOG.debug("Got response from NiFi with status code " + response.getStatus());
            }
            if (Response.Status.OK.getStatusCode() == response.getStatus()) {
                connectivityStatus = true;
            } else {
                connectivityStatus = false;
                errMsg = "Status Code = " + response.getStatus();
            }
        }
        catch (Exception e) {
            LOG.error("Connection to NiFi failed due to " + e.getMessage(), (Throwable)e);
            connectivityStatus = false;
            errMsg = e.getMessage();
        }
        if (connectivityStatus) {
            BaseClient.generateResponseDataMap((boolean)connectivityStatus, (String)SUCCESS_MSG, (String)SUCCESS_MSG, null, null, responseData);
        } else {
            BaseClient.generateResponseDataMap((boolean)connectivityStatus, (String)FAILURE_MSG, (String)(FAILURE_MSG + errMsg), null, null, responseData);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Response Data - " + responseData);
        }
        return responseData;
    }

    public List<String> getResources(ResourceLookupContext context) throws Exception {
        WebResource resource = this.getWebResource();
        ClientResponse response = this.getResponse(resource, "application/json");
        if (Response.Status.OK.getStatusCode() != response.getStatus()) {
            String errorMsg = IOUtils.toString((InputStream)response.getEntityInputStream());
            throw new Exception("Unable to retrieve resources from NiFi Registry due to: " + errorMsg);
        }
        JsonNode rootNode = this.mapper.readTree(response.getEntityInputStream());
        if (rootNode == null) {
            throw new Exception("Unable to retrieve resources from NiFi Registry");
        }
        List identifiers = rootNode.findValuesAsText("identifier");
        String userInput = context.getUserInput();
        if (StringUtils.isBlank((CharSequence)userInput)) {
            return identifiers;
        }
        ArrayList<String> filteredIdentifiers = new ArrayList<String>();
        for (String identifier : identifiers) {
            if (!identifier.contains(userInput)) continue;
            filteredIdentifiers.add(identifier);
        }
        return filteredIdentifiers;
    }

    protected WebResource getWebResource() {
        DefaultClientConfig config = new DefaultClientConfig();
        if (this.sslContext != null) {
            config.getProperties().put("com.sun.jersey.client.impl.urlconnection.httpsProperties", new HTTPSProperties(this.hostnameVerifier, this.sslContext));
        }
        Client client = Client.create((ClientConfig)config);
        return client.resource(this.url);
    }

    protected ClientResponse getResponse(WebResource resource, String accept) {
        return (ClientResponse)resource.accept(new String[]{accept}).get(ClientResponse.class);
    }

    public String getUrl() {
        return this.url;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    private static class NiFiRegistryHostnameVerifier
    implements HostnameVerifier {
        private NiFiRegistryHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession ssls) {
            try {
                Certificate[] certificates = ssls.getPeerCertificates();
                if (certificates == null || certificates.length == 0) {
                    return false;
                }
                if (certificates[0] instanceof X509Certificate) {
                    X509Certificate x509Cert = (X509Certificate)certificates[0];
                    List<String> subjectAltNames = this.getSubjectAlternativeNames(x509Cert);
                    return subjectAltNames.contains(hostname.toLowerCase());
                }
            }
            catch (CertificateParsingException | SSLPeerUnverifiedException ex) {
                LOG.warn("Hostname Verification encountered exception verifying hostname due to: " + ex, (Throwable)ex);
            }
            return false;
        }

        private List<String> getSubjectAlternativeNames(X509Certificate certificate) throws CertificateParsingException {
            ArrayList<String> result = new ArrayList<String>();
            Collection<List<?>> altNames = certificate.getSubjectAlternativeNames();
            if (altNames == null) {
                return result;
            }
            for (List<?> generalName : altNames) {
                Object value;
                if (generalName.size() <= 1 || !((value = generalName.get(1)) instanceof String)) continue;
                result.add(((String)value).toLowerCase());
            }
            return result;
        }
    }
}

