/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.type;

import io.airlift.slice.Slice;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.block.BlockBuilderStatus;
import io.prestosql.spi.block.LongArrayBlockBuilder;
import io.prestosql.spi.type.AbstractType;
import io.prestosql.spi.type.FixedWidthType;
import io.prestosql.spi.type.TypeSignature;

public abstract class AbstractLongType
extends AbstractType
implements FixedWidthType {
    public AbstractLongType(TypeSignature signature) {
        super(signature, Long.TYPE);
    }

    @Override
    public final int getFixedSize() {
        return 8;
    }

    @Override
    public boolean isComparable() {
        return true;
    }

    @Override
    public boolean isOrderable() {
        return true;
    }

    @Override
    public final long getLong(Block block, int position) {
        return block.getLong(position, 0);
    }

    @Override
    public final Slice getSlice(Block block, int position) {
        return block.getSlice(position, 0, this.getFixedSize());
    }

    @Override
    public final void writeLong(BlockBuilder blockBuilder, long value) {
        blockBuilder.writeLong(value).closeEntry();
    }

    @Override
    public final void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            blockBuilder.writeLong(block.getLong(position, 0)).closeEntry();
        }
    }

    @Override
    public boolean equalTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        long rightValue;
        long leftValue = leftBlock.getLong(leftPosition, 0);
        return leftValue == (rightValue = rightBlock.getLong(rightPosition, 0));
    }

    @Override
    public long hash(Block block, int position) {
        return AbstractLongType.hash(block.getLong(position, 0));
    }

    @Override
    public int compareTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        long leftValue = leftBlock.getLong(leftPosition, 0);
        long rightValue = rightBlock.getLong(rightPosition, 0);
        return Long.compare(leftValue, rightValue);
    }

    @Override
    public final BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        int maxBlockSizeInBytes = blockBuilderStatus == null ? 0x100000 : blockBuilderStatus.getMaxPageSizeInBytes();
        return new LongArrayBlockBuilder(blockBuilderStatus, Math.min(expectedEntries, maxBlockSizeInBytes / 8));
    }

    @Override
    public final BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return this.createBlockBuilder(blockBuilderStatus, expectedEntries, 8);
    }

    @Override
    public final BlockBuilder createFixedSizeBlockBuilder(int positionCount) {
        return new LongArrayBlockBuilder(null, positionCount);
    }

    public static long hash(long value) {
        return Long.rotateLeft(value * -4417276706812531889L, 31) * -7046029288634856825L;
    }
}

