/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hdds.conf.Config;
import org.apache.hadoop.hdds.conf.ConfigGroup;
import org.apache.hadoop.hdds.conf.ConfigTag;
import org.apache.hadoop.hdds.conf.ConfigType;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.XceiverClientCreator;
import org.apache.hadoop.hdds.scm.XceiverClientMetrics;
import org.apache.hadoop.hdds.scm.XceiverClientSpi;
import org.apache.hadoop.hdds.scm.client.ClientTrustManager;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.ozone.util.CacheMetrics;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XceiverClientManager
extends XceiverClientCreator {
    private static final Logger LOG = LoggerFactory.getLogger(XceiverClientManager.class);
    private final Cache<String, XceiverClientSpi> clientCache;
    private final CacheMetrics cacheMetrics;
    private static XceiverClientMetrics metrics;

    public XceiverClientManager(ConfigurationSource conf) throws IOException {
        this(conf, (ScmClientConfig)conf.getObject(ScmClientConfig.class), null);
    }

    public XceiverClientManager(ConfigurationSource conf, ScmClientConfig clientConf, ClientTrustManager trustManager) throws IOException {
        super(conf, trustManager);
        Preconditions.checkNotNull((Object)clientConf);
        Preconditions.checkNotNull((Object)conf);
        long staleThresholdMs = clientConf.getStaleThreshold(TimeUnit.MILLISECONDS);
        this.clientCache = CacheBuilder.newBuilder().recordStats().expireAfterAccess(staleThresholdMs, TimeUnit.MILLISECONDS).maximumSize((long)clientConf.getMaxSize()).removalListener((RemovalListener)new RemovalListener<String, XceiverClientSpi>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onRemoval(RemovalNotification<String, XceiverClientSpi> removalNotification) {
                Cache cache = XceiverClientManager.this.clientCache;
                synchronized (cache) {
                    XceiverClientSpi info = (XceiverClientSpi)removalNotification.getValue();
                    info.setEvicted();
                }
            }
        }).build();
        this.cacheMetrics = CacheMetrics.create(this.clientCache, (Object)this);
    }

    @VisibleForTesting
    public Cache<String, XceiverClientSpi> getClientCache() {
        return this.clientCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XceiverClientSpi acquireClient(Pipeline pipeline, boolean topologyAware) throws IOException {
        Preconditions.checkNotNull((Object)pipeline);
        Preconditions.checkArgument((pipeline.getNodes() != null ? 1 : 0) != 0);
        Preconditions.checkArgument((!pipeline.getNodes().isEmpty() ? 1 : 0) != 0, (Object)SCMException.ResultCodes.NO_REPLICA_FOUND);
        Cache<String, XceiverClientSpi> cache = this.clientCache;
        synchronized (cache) {
            XceiverClientSpi info = this.getClient(pipeline, topologyAware);
            info.incrementReference();
            return info;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseClient(XceiverClientSpi client, boolean invalidateClient, boolean topologyAware) {
        Preconditions.checkNotNull((Object)client);
        Cache<String, XceiverClientSpi> cache = this.clientCache;
        synchronized (cache) {
            Pipeline pipeline;
            String key;
            XceiverClientSpi cachedClient;
            client.decrementReference();
            if (invalidateClient && (cachedClient = (XceiverClientSpi)this.clientCache.getIfPresent((Object)(key = this.getPipelineCacheKey(pipeline = client.getPipeline(), topologyAware)))) == client) {
                this.clientCache.invalidate((Object)key);
            }
        }
    }

    protected XceiverClientSpi getClient(Pipeline pipeline, boolean topologyAware) throws IOException {
        try {
            String key = this.getPipelineCacheKey(pipeline, topologyAware);
            return (XceiverClientSpi)this.clientCache.get((Object)key, () -> this.newClient(pipeline));
        }
        catch (Exception e) {
            throw new IOException("Exception getting XceiverClient: " + e, e);
        }
    }

    private String getPipelineCacheKey(Pipeline pipeline, boolean topologyAware) {
        boolean isEC;
        String key = pipeline.getId().getId().toString() + pipeline.getType();
        boolean bl = isEC = pipeline.getType() == HddsProtos.ReplicationType.EC;
        if (topologyAware || isEC) {
            try {
                DatanodeDetails closestNode = pipeline.getClosestNode();
                key = key + closestNode.getHostName() + closestNode.getStandalonePort();
            }
            catch (IOException e) {
                LOG.error("Failed to get closest node to create pipeline cache key:" + e.getMessage());
            }
        }
        if (this.isSecurityEnabled()) {
            try {
                key = key + UserGroupInformation.getCurrentUser().getShortUserName();
            }
            catch (IOException e) {
                LOG.error("Failed to get current user to create pipeline cache key:" + e.getMessage());
            }
        }
        return key;
    }

    @Override
    public void close() {
        this.clientCache.invalidateAll();
        this.clientCache.cleanUp();
        if (LOG.isDebugEnabled()) {
            LOG.debug("XceiverClient cache stats: {}", (Object)this.clientCache.stats());
        }
        this.cacheMetrics.unregister();
        if (metrics != null) {
            metrics.unRegister();
        }
    }

    public static synchronized XceiverClientMetrics getXceiverClientMetrics() {
        if (metrics == null) {
            metrics = XceiverClientMetrics.create();
        }
        return metrics;
    }

    public static synchronized void resetXceiverClientMetrics() {
        if (metrics != null) {
            metrics.reset();
        }
    }

    @ConfigGroup(prefix="scm.container.client")
    public static class ScmClientConfig {
        @Config(key="max.size", defaultValue="256", tags={ConfigTag.OZONE, ConfigTag.PERFORMANCE}, description="Controls the maximum number of connections that are cached via client connection pooling. If the number of connections exceed this count, then the oldest idle connection is evicted.")
        private int maxSize;
        @Config(key="idle.threshold", type=ConfigType.TIME, timeUnit=TimeUnit.MILLISECONDS, defaultValue="10s", tags={ConfigTag.OZONE, ConfigTag.PERFORMANCE}, description="In the standalone pipelines, the SCM clients use netty to  communicate with the container. It also uses connection pooling to reduce client side overheads. This allows a connection to stay idle for a while before the connection is closed.")
        private long staleThreshold;

        public long getStaleThreshold(TimeUnit unit) {
            return unit.convert(this.staleThreshold, TimeUnit.MILLISECONDS);
        }

        public int getMaxSize() {
            return this.maxSize;
        }

        @VisibleForTesting
        public void setMaxSize(int maxSize) {
            this.maxSize = maxSize;
        }

        public void setStaleThreshold(long threshold) {
            this.staleThreshold = threshold;
        }
    }

    public static class XceiverClientManagerConfigBuilder {
        private int maxCacheSize;
        private long staleThresholdMs;

        public XceiverClientManagerConfigBuilder setMaxCacheSize(int maxCacheSize) {
            this.maxCacheSize = maxCacheSize;
            return this;
        }

        public XceiverClientManagerConfigBuilder setStaleThresholdMs(long staleThresholdMs) {
            this.staleThresholdMs = staleThresholdMs;
            return this;
        }

        public ScmClientConfig build() {
            ScmClientConfig clientConfig = new ScmClientConfig();
            clientConfig.setMaxSize(this.maxCacheSize);
            clientConfig.setStaleThreshold(this.staleThresholdMs);
            return clientConfig;
        }
    }
}

