/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.conf;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.SimpleTypeVisitor8;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.apache.hadoop.hdds.conf.Config;
import org.apache.hadoop.hdds.conf.ConfigFileAppender;
import org.apache.hadoop.hdds.conf.ConfigGroup;
import org.apache.hadoop.hdds.conf.ConfigurationReflectionUtil;

@SupportedAnnotationTypes(value={"org.apache.hadoop.hdds.conf.ConfigGroup"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class ConfigFileGenerator
extends AbstractProcessor {
    private static final String OUTPUT_FILE_NAME = "ozone-default-generated.xml";
    private static final String OUTPUT_FILE_POSTFIX = "-default.xml";
    private static final SimpleTypeVisitor8<Element, Void> GET_PARENT_ELEMENT = new SimpleTypeVisitor8<Element, Void>(){

        @Override
        public Element visitDeclared(DeclaredType t, Void aVoid) {
            return t.asElement();
        }
    };

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        block20: {
            if (roundEnv.processingOver()) {
                return false;
            }
            Filer filer = this.processingEnv.getFiler();
            try {
                boolean resourceExists = true;
                ConfigFileAppender appender = new ConfigFileAppender();
                String currentArtifactId = this.processingEnv.getOptions().get("artifactId");
                String outputFileName = currentArtifactId == null || currentArtifactId.isEmpty() ? OUTPUT_FILE_NAME : currentArtifactId + OUTPUT_FILE_POSTFIX;
                try (InputStream input = filer.getResource(StandardLocation.CLASS_OUTPUT, "", outputFileName).openInputStream();){
                    appender.load(input);
                }
                catch (FileNotFoundException | NoSuchFileException ex) {
                    appender.init();
                    resourceExists = false;
                }
                Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(ConfigGroup.class);
                for (Element element : annotatedElements) {
                    TypeElement configurationObject = (TypeElement)element;
                    ConfigGroup configGroupAnnotation = configurationObject.getAnnotation(ConfigGroup.class);
                    TypeElement elementToCheck = configurationObject;
                    while (elementToCheck != null) {
                        this.writeConfigAnnotations(configGroupAnnotation, appender, elementToCheck);
                        if (!elementToCheck.getSuperclass().toString().equals("java.lang.Object")) {
                            elementToCheck = (TypeElement)elementToCheck.getSuperclass().accept(GET_PARENT_ELEMENT, null);
                            continue;
                        }
                        elementToCheck = null;
                    }
                }
                if (resourceExists) break block20;
                FileObject resource = filer.createResource(StandardLocation.CLASS_OUTPUT, "", outputFileName, new Element[0]);
                try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter(resource.openOutputStream(), StandardCharsets.UTF_8);){
                    appender.write(outputStreamWriter);
                }
            }
            catch (IOException e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Can't generate the config file from annotation: " + e);
            }
        }
        return false;
    }

    private void writeConfigAnnotations(ConfigGroup configGroup, ConfigFileAppender appender, TypeElement typeElement) {
        for (Element element : typeElement.getEnclosedElements()) {
            if (element.getKind() != ElementKind.FIELD || element.getAnnotation(Config.class) == null) continue;
            Config configAnnotation = element.getAnnotation(Config.class);
            String key = ConfigurationReflectionUtil.getFullKey(configGroup, configAnnotation);
            appender.addConfig(key, configAnnotation.defaultValue(), configAnnotation.description(), configAnnotation.tags());
        }
    }
}

