/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.store;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.ranger.authorization.hadoop.config.RangerAdminConfig;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceResource;

public class RangerServiceResourceSignature {
    private final String _string;
    private final String _hash;

    public RangerServiceResourceSignature(RangerServiceResource serviceResource) {
        this._string = ServiceResourceSerializer.toString(serviceResource);
        this._hash = RangerAdminConfig.getInstance().isFipsEnabled() ? DigestUtils.sha512Hex((String)this._string) : DigestUtils.sha256Hex((String)this._string);
    }

    String asString() {
        return this._string;
    }

    public String getSignature() {
        return this._hash;
    }

    static class ServiceResourceSerializer {
        static final int _SignatureVersion = 1;

        ServiceResourceSerializer() {
        }

        public static String toString(RangerServiceResource serviceResource) {
            Map<String, RangerPolicy.RangerPolicyResource> resource = serviceResource.getResourceElements();
            TreeMap<String, ResourceSerializer> resources = new TreeMap<String, ResourceSerializer>();
            for (Map.Entry<String, RangerPolicy.RangerPolicyResource> entry : resource.entrySet()) {
                String resourceName = entry.getKey();
                ResourceSerializer resourceView = new ResourceSerializer(entry.getValue());
                resources.put(resourceName, resourceView);
            }
            String resourcesAsString = ((Object)resources).toString();
            return String.format("{version=%d,resource=%s}", 1, resourcesAsString);
        }

        static class ResourceSerializer {
            final RangerPolicy.RangerPolicyResource _policyResource;

            ResourceSerializer(RangerPolicy.RangerPolicyResource policyResource) {
                this._policyResource = policyResource;
            }

            public String toString() {
                StringBuilder builder = new StringBuilder();
                builder.append("{");
                if (this._policyResource != null) {
                    builder.append("values=");
                    if (this._policyResource.getValues() != null) {
                        ArrayList<String> values = new ArrayList<String>(this._policyResource.getValues());
                        Collections.sort(values);
                        builder.append(values);
                    }
                    builder.append(",excludes=");
                    if (this._policyResource.getIsExcludes() == null) {
                        builder.append(Boolean.FALSE);
                    } else {
                        builder.append(this._policyResource.getIsExcludes());
                    }
                    builder.append(",recursive=");
                    if (this._policyResource.getIsRecursive() == null) {
                        builder.append(Boolean.FALSE);
                    } else {
                        builder.append(this._policyResource.getIsRecursive());
                    }
                }
                builder.append("}");
                return builder.toString();
            }
        }
    }
}

