/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyevaluator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ranger.plugin.model.RangerBaseModelObject;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngineOptions;
import org.apache.ranger.plugin.policyevaluator.RangerDefaultPolicyEvaluator;
import org.apache.ranger.plugin.policyevaluator.RangerPolicyItemEvaluator;
import org.apache.ranger.plugin.util.RangerAccessRequestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerOptimizedPolicyEvaluator
extends RangerDefaultPolicyEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(RangerOptimizedPolicyEvaluator.class);
    private Set<String> roles = RangerBaseModelObject.nullSafeSet(null);
    private Set<String> groups = RangerBaseModelObject.nullSafeSet(null);
    private Set<String> users = RangerBaseModelObject.nullSafeSet(null);
    private Set<String> accessPerms = RangerBaseModelObject.nullSafeSet(null);
    private boolean delegateAdmin;
    private boolean hasAllPerms;
    private boolean hasPublicGroup;
    private boolean hasCurrentUser;
    private boolean hasResourceOwner;
    private boolean hasAllEvaluatorsInitialized;
    private static final String RANGER_POLICY_EVAL_MATCH_ANY_PATTERN_STRING = "*";
    private static final String RANGER_POLICY_EVAL_MATCH_ONE_CHARACTER_STRING = "?";
    private static final int RANGER_POLICY_EVAL_SCORE_DEFAULT = 10000;
    private static final int RANGER_POLICY_EVAL_SCORE_MAX_DISCOUNT_RESOURCE = 100;
    private static final int RANGER_POLICY_EVAL_SCORE_MAX_DISCOUNT_USERSGROUPS = 25;
    private static final int RANGER_POLICY_EVAL_SCORE_MAX_DISCOUNT_ACCESS_TYPES = 25;
    private static final int RANGER_POLICY_EVAL_SCORE_MAX_DISCOUNT_CUSTOM_CONDITIONS = 25;
    private static final int RANGER_POLICY_EVAL_SCORE_RESOURCE_DISCOUNT_MATCH_ANY_WILDCARD = 25;
    private static final int RANGER_POLICY_EVAL_SCORE_RESOURCE_DISCOUNT_HAS_MATCH_ANY_WILDCARD = 10;
    private static final int RANGER_POLICY_EVAL_SCORE_RESOURCE_DISCOUNT_HAS_MATCH_ONE_CHARACTER_WILDCARD = 5;
    private static final int RANGER_POLICY_EVAL_SCORE_RESOURCE_DISCOUNT_IS_EXCLUDES = 5;
    private static final int RANGER_POLICY_EVAL_SCORE_RESORUCE_DISCOUNT_IS_RECURSIVE = 5;
    private static final int RANGER_POLICY_EVAL_SCORE_CUSTOM_CONDITION_PENALTY = 5;
    private static final int RANGER_POLICY_EVAL_SCORE_DYNAMIC_RESOURCE_EVAL_PENALTY = 20;

    @Override
    public void init(RangerPolicy policy, RangerServiceDef serviceDef, RangerPolicyEngineOptions options) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerOptimizedPolicyEvaluator.init()");
        }
        super.init(policy, serviceDef, options);
        this.preprocessPolicyItems(policy.getPolicyItems());
        this.preprocessPolicyItems(policy.getDenyPolicyItems());
        this.preprocessPolicyItems(policy.getAllowExceptions());
        this.preprocessPolicyItems(policy.getDenyExceptions());
        this.preprocessPolicyItems(policy.getDataMaskPolicyItems());
        this.preprocessPolicyItems(policy.getRowFilterPolicyItems());
        this.hasAllPerms = this.checkIfHasAllPerms();
        for (String user : this.users) {
            if (!this.hasCurrentUser && "{USER}".equalsIgnoreCase(user)) {
                this.hasCurrentUser = true;
            }
            if (!this.hasResourceOwner && "{OWNER}".equalsIgnoreCase(user)) {
                this.hasResourceOwner = true;
            }
            if (!this.hasCurrentUser || !this.hasResourceOwner) continue;
            break;
        }
        if (policy.getIsDenyAllElse().booleanValue()) {
            this.hasPublicGroup = true;
        } else {
            for (String group : this.groups) {
                if (!"public".equalsIgnoreCase(group)) continue;
                this.hasPublicGroup = true;
                break;
            }
        }
        this.setEvalOrder(this.computeEvalOrder());
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerOptimizedPolicyEvaluator.init()");
        }
    }

    public int computeEvalOrder() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerOptimizedPolicyEvaluator.computeEvalOrder()");
        }
        int evalOrder = 10000;
        RangerServiceDef serviceDef = this.getServiceDef();
        List<RangerServiceDef.RangerResourceDef> resourceDefs = serviceDef.getResources();
        RangerPolicy policy = this.getPolicy();
        ArrayList<LevelResourceNames> tmpList = new ArrayList<LevelResourceNames>();
        block0: for (Map.Entry<String, RangerPolicy.RangerPolicyResource> entry : policy.getResources().entrySet()) {
            String resourceName = entry.getKey();
            RangerPolicy.RangerPolicyResource policyResource = entry.getValue();
            List<String> resourceValues = policyResource.getValues();
            if (!CollectionUtils.isNotEmpty(resourceValues)) continue;
            for (RangerServiceDef.RangerResourceDef rangerResourceDef : resourceDefs) {
                if (!resourceName.equals(rangerResourceDef.getName())) continue;
                tmpList.add(new LevelResourceNames(rangerResourceDef.getLevel(), policyResource));
                continue block0;
            }
        }
        Collections.sort(tmpList);
        int resourceDiscount = 0;
        for (LevelResourceNames item : tmpList) {
            boolean foundStarWildcard = false;
            boolean foundQuestionWildcard = false;
            boolean foundMatchAny = false;
            for (String resourceName : item.policyResource.getValues()) {
                if (resourceName.isEmpty() || RANGER_POLICY_EVAL_MATCH_ANY_PATTERN_STRING.equals(resourceName)) {
                    foundMatchAny = true;
                    break;
                }
                if (resourceName.contains(RANGER_POLICY_EVAL_MATCH_ANY_PATTERN_STRING)) {
                    foundStarWildcard = true;
                    continue;
                }
                if (!resourceName.contains(RANGER_POLICY_EVAL_MATCH_ONE_CHARACTER_STRING)) continue;
                foundQuestionWildcard = true;
            }
            if (foundMatchAny) {
                resourceDiscount += 25;
                continue;
            }
            if (foundStarWildcard) {
                resourceDiscount += 10;
            } else if (foundQuestionWildcard) {
                resourceDiscount += 5;
            }
            RangerPolicy.RangerPolicyResource rangerPolicyResource = item.policyResource;
            if (rangerPolicyResource.getIsExcludes().booleanValue()) {
                resourceDiscount += 5;
            }
            if (!rangerPolicyResource.getIsRecursive().booleanValue()) continue;
            resourceDiscount += 5;
        }
        if (this.needsDynamicEval()) {
            evalOrder += 20;
        }
        evalOrder -= Math.min(100, resourceDiscount);
        evalOrder = this.hasPublicGroup || this.hasCurrentUser ? (evalOrder -= 25) : (evalOrder -= Math.min(this.groups.size() + this.users.size(), 25));
        evalOrder -= Math.round(25.0f * (float)this.accessPerms.size() / (float)serviceDef.getAccessTypes().size());
        int n = 25 - 5 * this.getCustomConditionsCount();
        if (n > 0) {
            evalOrder -= n;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerOptimizedPolicyEvaluator.computeEvalOrder(), policyName:" + policy.getName() + ", priority:" + evalOrder);
        }
        return evalOrder;
    }

    @Override
    protected boolean isAccessAllowed(String user, Set<String> userGroups, Set<String> roles, String owner, String accessType) {
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerOptimizedPolicyEvaluator.isAccessAllowed(" + user + ", " + userGroups + ", " + roles + ", " + owner + ", " + accessType + ")");
        }
        boolean bl = ret = this.hasMatchablePolicyItem(user, userGroups, roles, owner, accessType) && super.isAccessAllowed(user, userGroups, roles, owner, accessType);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerOptimizedPolicyEvaluator.isAccessAllowed(" + user + ", " + userGroups + ", " + roles + ", " + owner + ", " + accessType + "): " + ret);
        }
        return ret;
    }

    @Override
    protected boolean hasMatchablePolicyItem(RangerAccessRequest request) {
        boolean ret = false;
        if (this.checkIfAllEvaluatorsInitialized()) {
            if (this.hasPublicGroup || this.hasCurrentUser || this.isOwnerMatch(request) || this.users.contains(request.getUser()) || CollectionUtils.containsAny(this.groups, request.getUserGroups()) || CollectionUtils.isNotEmpty(this.roles) && CollectionUtils.containsAny(this.roles, RangerAccessRequestUtil.getCurrentUserRolesFromContext(request.getContext()))) {
                if (this.hasAllPerms || request.isAccessTypeAny()) {
                    ret = true;
                } else {
                    ret = this.accessPerms.contains(request.getAccessType());
                    if (!ret) {
                        Set<String> allRequestedAccesses = RangerAccessRequestUtil.getAllRequestedAccessTypes(request);
                        ret = CollectionUtils.containsAny(this.accessPerms, allRequestedAccesses);
                    }
                    if (!ret && request.isAccessTypeDelegatedAdmin()) {
                        ret = this.delegateAdmin;
                    }
                }
            }
        } else {
            ret = true;
        }
        return ret;
    }

    private boolean isOwnerMatch(RangerAccessRequest request) {
        boolean ret = false;
        if (this.hasResourceOwner) {
            RangerAccessResource accessedResource = request.getResource();
            String resourceOwner = accessedResource != null ? accessedResource.getOwnerUser() : null;
            String user = request.getUser();
            if (user != null && resourceOwner != null && user.equals(resourceOwner)) {
                ret = true;
            }
        }
        return ret;
    }

    private boolean hasMatchablePolicyItem(String user, Set<String> userGroups, Set<String> rolesFromContext, String owner, String accessType) {
        boolean ret = false;
        if (this.checkIfAllEvaluatorsInitialized()) {
            boolean hasRole = false;
            if (CollectionUtils.isNotEmpty(this.roles) && CollectionUtils.isNotEmpty(rolesFromContext)) {
                hasRole = CollectionUtils.containsAny(this.roles, rolesFromContext);
            }
            if (this.hasPublicGroup || this.hasCurrentUser || this.users.contains(user) || CollectionUtils.containsAny(this.groups, userGroups) || hasRole || this.hasResourceOwner && StringUtils.equals((CharSequence)user, (CharSequence)owner)) {
                if (this.hasAllPerms) {
                    ret = true;
                } else {
                    boolean isAccessTypeAny = StringUtils.isEmpty((CharSequence)accessType) || StringUtils.equals((CharSequence)accessType, (CharSequence)"_any");
                    boolean bl = ret = isAccessTypeAny || this.accessPerms.contains(accessType);
                    if (!ret && StringUtils.equals((CharSequence)accessType, (CharSequence)"_admin")) {
                        ret = this.delegateAdmin;
                    }
                }
            }
        } else {
            ret = true;
        }
        return ret;
    }

    private static Set<String> addAll(Set<String> coll, Collection<String> toAdd) {
        if (CollectionUtils.isNotEmpty(toAdd)) {
            if (CollectionUtils.isEmpty(coll)) {
                coll = new HashSet<String>(toAdd);
            } else {
                coll.addAll(toAdd);
            }
        }
        return coll;
    }

    private static Set<String> add(Set<String> coll, String value) {
        if (CollectionUtils.isEmpty(coll)) {
            coll = new HashSet<String>();
        }
        coll.add(value);
        return coll;
    }

    private void preprocessPolicyItems(List<? extends RangerPolicy.RangerPolicyItem> policyItems) {
        if (CollectionUtils.isNotEmpty(policyItems)) {
            for (RangerPolicy.RangerPolicyItem rangerPolicyItem : policyItems) {
                this.delegateAdmin = this.delegateAdmin || rangerPolicyItem.getDelegateAdmin() != false;
                List<RangerPolicy.RangerPolicyItemAccess> policyItemAccesses = rangerPolicyItem.getAccesses();
                for (RangerPolicy.RangerPolicyItemAccess policyItemAccess : policyItemAccesses) {
                    if (!policyItemAccess.getIsAllowed().booleanValue()) continue;
                    this.accessPerms = RangerOptimizedPolicyEvaluator.add(this.accessPerms, policyItemAccess.getType());
                }
                this.roles = RangerOptimizedPolicyEvaluator.addAll(this.roles, rangerPolicyItem.getRoles());
                this.groups = RangerOptimizedPolicyEvaluator.addAll(this.groups, rangerPolicyItem.getGroups());
                this.users = RangerOptimizedPolicyEvaluator.addAll(this.users, rangerPolicyItem.getUsers());
            }
        }
    }

    private boolean checkIfHasAllPerms() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerOptimizedPolicyEvaluator.checkIfHasAllPerms()");
        }
        boolean result = true;
        if (this.getPolicy().getIsDenyAllElse().booleanValue()) {
            this.hasAllPerms = true;
        } else {
            List<RangerServiceDef.RangerAccessTypeDef> serviceAccessTypes = this.getServiceDef().getAccessTypes();
            for (RangerServiceDef.RangerAccessTypeDef serviceAccessType : serviceAccessTypes) {
                if (this.accessPerms.contains(serviceAccessType.getName())) continue;
                result = false;
                break;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerOptimizedPolicyEvaluator.checkIfHasAllPerms(), " + result);
        }
        return result;
    }

    private boolean checkIfAllEvaluatorsInitialized() {
        if (!this.hasAllEvaluatorsInitialized) {
            this.hasAllEvaluatorsInitialized = this.checkIfWithImpliedGrantsInitialized(this.getAllowEvaluators()) && this.checkIfWithImpliedGrantsInitialized(this.getAllowExceptionEvaluators()) && this.checkIfWithImpliedGrantsInitialized(this.getDenyEvaluators()) && this.checkIfWithImpliedGrantsInitialized(this.getDenyExceptionEvaluators()) && this.checkIfWithImpliedGrantsInitialized(this.getDataMaskEvaluators()) && this.checkIfWithImpliedGrantsInitialized(this.getRowFilterEvaluators());
        }
        return this.hasAllEvaluatorsInitialized;
    }

    private boolean checkIfWithImpliedGrantsInitialized(List<? extends RangerPolicyItemEvaluator> evaluators) {
        boolean ret = true;
        for (RangerPolicyItemEvaluator rangerPolicyItemEvaluator : evaluators) {
            if (rangerPolicyItemEvaluator.getWithImpliedGrants() == null) {
                ret = false;
                break;
            }
            for (RangerPolicy.RangerPolicyItemAccess access : rangerPolicyItemEvaluator.getWithImpliedGrants().getAccesses()) {
                if (!access.getIsAllowed().booleanValue()) continue;
                if (CollectionUtils.isEmpty(this.accessPerms)) {
                    this.accessPerms = new HashSet<String>();
                }
                this.accessPerms.add(access.getType());
            }
        }
        return ret;
    }

    static class LevelResourceNames
    implements Comparable<LevelResourceNames> {
        final int level;
        final RangerPolicy.RangerPolicyResource policyResource;

        public LevelResourceNames(int level, RangerPolicy.RangerPolicyResource policyResource) {
            this.level = level;
            this.policyResource = policyResource;
        }

        @Override
        public int compareTo(LevelResourceNames other) {
            return Integer.compare(this.level, other.level);
        }

        public boolean equals(Object other) {
            boolean ret = false;
            if (other != null && other instanceof LevelResourceNames) {
                ret = this == other || this.compareTo((LevelResourceNames)other) == 0;
            }
            return ret;
        }

        public int hashCode() {
            return Objects.hashCode(this.level);
        }
    }
}

