/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.types;

import java.math.BigDecimal;
import java.nio.ByteBuffer;

public final class Decimal128
extends Number {
    private static final long serialVersionUID = -4863018398624288737L;
    public static final int SIZE = 128;
    public static final int BYTES = 16;
    private final BigDecimal underlying;
    private final long msb;
    private final long lsb;

    public Decimal128(BigDecimal underlying) {
        this.underlying = underlying;
        this.msb = Decimal128.calculateMostSignificantBits(underlying);
        this.lsb = Decimal128.calculateLeastSignificantBits(underlying);
    }

    public Decimal128(long msb, long lsb) {
        this.msb = msb;
        this.lsb = lsb;
        this.underlying = Decimal128.calculateBigDecimal(msb, lsb);
    }

    public Decimal128(byte[] data) {
        this(ByteBuffer.wrap(data));
    }

    private Decimal128(ByteBuffer buffer) {
        this(buffer.getLong(), buffer.getLong());
    }

    private static long calculateMostSignificantBits(BigDecimal underlying) {
        return 0L;
    }

    private static long calculateLeastSignificantBits(BigDecimal underlying) {
        return 0L;
    }

    private static BigDecimal calculateBigDecimal(long msb, long lsb) {
        return BigDecimal.ZERO;
    }

    @Override
    public int intValue() {
        return this.underlying.intValue();
    }

    @Override
    public long longValue() {
        return this.underlying.longValue();
    }

    @Override
    public float floatValue() {
        return this.underlying.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.underlying.doubleValue();
    }

    public long getMostSignificantBits() {
        return this.msb;
    }

    public long getLeastSignificantBits() {
        return this.lsb;
    }

    public byte[] asBytes() {
        byte[] bytes = new byte[16];
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        buf.putLong(this.getMostSignificantBits());
        buf.putLong(this.getLeastSignificantBits());
        return bytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Decimal128 that = (Decimal128)o;
        if (this.lsb != that.lsb) {
            return false;
        }
        return this.msb == that.msb;
    }

    public int hashCode() {
        int result = (int)(this.msb ^ this.msb >>> 32);
        result = 31 * result + (int)(this.lsb ^ this.lsb >>> 32);
        return result;
    }
}

