/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.encoders.primitives;

import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.EncoderState;
import org.apache.qpid.protonj2.codec.encoders.AbstractPrimitiveTypeEncoder;
import org.apache.qpid.protonj2.types.UnsignedShort;

public final class UnsignedShortTypeEncoder
extends AbstractPrimitiveTypeEncoder<UnsignedShort> {
    @Override
    public Class<UnsignedShort> getTypeClass() {
        return UnsignedShort.class;
    }

    @Override
    public void writeType(ProtonBuffer buffer, EncoderState state, UnsignedShort value) {
        buffer.writeByte((byte)96);
        buffer.writeShort(value.shortValue());
    }

    @Override
    public void writeType(ProtonBuffer buffer, EncoderState state, short value) {
        buffer.writeByte((byte)96);
        buffer.writeShort(value);
    }

    @Override
    public void writeType(ProtonBuffer buffer, EncoderState state, int value) {
        if (value < 0 || value > 65535) {
            throw new IllegalArgumentException("Value given is out of range: " + value);
        }
        this.writeType(buffer, state, (short)value);
    }

    @Override
    public void writeRawArray(ProtonBuffer buffer, EncoderState state, Object[] values) {
        buffer.writeByte((byte)96);
        for (Object value : values) {
            buffer.writeShort(((UnsignedShort)value).shortValue());
        }
    }
}

