/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.decoders.messaging;

import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.DecodeException;
import org.apache.qpid.protonj2.codec.DecoderState;
import org.apache.qpid.protonj2.codec.StreamDecoderState;
import org.apache.qpid.protonj2.codec.StreamTypeDecoder;
import org.apache.qpid.protonj2.codec.TypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.AbstractDescribedMapTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.ProtonScanningContext;
import org.apache.qpid.protonj2.codec.decoders.ScanningContext;
import org.apache.qpid.protonj2.codec.decoders.StreamScanningContext;
import org.apache.qpid.protonj2.codec.decoders.primitives.MapTypeDecoder;
import org.apache.qpid.protonj2.types.Symbol;
import org.apache.qpid.protonj2.types.UnsignedLong;
import org.apache.qpid.protonj2.types.messaging.DeliveryAnnotations;

public final class DeliveryAnnotationsTypeDecoder
extends AbstractDescribedMapTypeDecoder<DeliveryAnnotations> {
    @Override
    public Class<DeliveryAnnotations> getTypeClass() {
        return DeliveryAnnotations.class;
    }

    @Override
    public UnsignedLong getDescriptorCode() {
        return DeliveryAnnotations.DESCRIPTOR_CODE;
    }

    @Override
    public Symbol getDescriptorSymbol() {
        return DeliveryAnnotations.DESCRIPTOR_SYMBOL;
    }

    @Override
    public DeliveryAnnotations readValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        if (decoder.isNull()) {
            return new DeliveryAnnotations(null);
        }
        return new DeliveryAnnotations(this.readMap(buffer, state, (MapTypeDecoder)DeliveryAnnotationsTypeDecoder.checkIsExpectedTypeAndCast(MapTypeDecoder.class, decoder)));
    }

    public DeliveryAnnotations[] readArrayElements(ProtonBuffer buffer, DecoderState state, int count) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        DeliveryAnnotations[] result = new DeliveryAnnotations[count];
        if (decoder.isNull()) {
            for (int i = 0; i < count; ++i) {
                result[i] = new DeliveryAnnotations(null);
            }
            return result;
        }
        for (int i = 0; i < count; ++i) {
            result[i] = new DeliveryAnnotations(this.readMap(buffer, state, (MapTypeDecoder)DeliveryAnnotationsTypeDecoder.checkIsExpectedTypeAndCast(MapTypeDecoder.class, decoder)));
        }
        return result;
    }

    private Map<Symbol, Object> readMap(ProtonBuffer buffer, DecoderState state, MapTypeDecoder mapDecoder) throws DecodeException {
        int size = mapDecoder.readSize(buffer, state);
        int count = mapDecoder.readCount(buffer, state);
        if (count > buffer.getReadableBytes()) {
            throw new DecodeException(String.format("Map encoded size %d is specified to be greater than the amount of data available (%d)", size, buffer.getReadableBytes()));
        }
        LinkedHashMap<Symbol, Object> map = new LinkedHashMap<Symbol, Object>(count);
        for (int i = 0; i < count / 2; ++i) {
            Symbol key = state.getDecoder().readSymbol(buffer, state);
            Object value = state.getDecoder().readObject(buffer, state);
            map.put(key, value);
        }
        return map;
    }

    @Override
    public DeliveryAnnotations readValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        if (decoder.isNull()) {
            return new DeliveryAnnotations(null);
        }
        return new DeliveryAnnotations(this.readMap(stream, state, (MapTypeDecoder)DeliveryAnnotationsTypeDecoder.checkIsExpectedTypeAndCast(MapTypeDecoder.class, decoder)));
    }

    public DeliveryAnnotations[] readArrayElements(InputStream stream, StreamDecoderState state, int count) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        DeliveryAnnotations[] result = new DeliveryAnnotations[count];
        if (decoder.isNull()) {
            for (int i = 0; i < count; ++i) {
                result[i] = new DeliveryAnnotations(null);
            }
            return result;
        }
        for (int i = 0; i < count; ++i) {
            result[i] = new DeliveryAnnotations(this.readMap(stream, state, (MapTypeDecoder)DeliveryAnnotationsTypeDecoder.checkIsExpectedTypeAndCast(MapTypeDecoder.class, decoder)));
        }
        return result;
    }

    private Map<Symbol, Object> readMap(InputStream stream, StreamDecoderState state, MapTypeDecoder mapDecoder) throws DecodeException {
        int size = mapDecoder.readSize(stream, state);
        int count = mapDecoder.readCount(stream, state);
        LinkedHashMap<Symbol, Object> map = new LinkedHashMap<Symbol, Object>(count);
        for (int i = 0; i < count / 2; ++i) {
            Symbol key = state.getDecoder().readSymbol(stream, state);
            Object value = state.getDecoder().readObject(stream, state);
            map.put(key, value);
        }
        return map;
    }

    public static ScanningContext<Symbol> createScanContext(Symbol ... keys) {
        return ProtonScanningContext.createSymbolScanContext(keys);
    }

    public static ScanningContext<Symbol> createScanContext(Collection<Symbol> keys) {
        return ProtonScanningContext.createSymbolScanContext(keys);
    }

    public static StreamScanningContext<Symbol> createStreamScanContext(Symbol ... keys) {
        return ProtonScanningContext.createSymbolScanContext(keys);
    }

    public static StreamScanningContext<Symbol> createStreamScanContext(Collection<Symbol> keys) {
        return ProtonScanningContext.createSymbolScanContext(keys);
    }

    public void scanAnnotations(ProtonBuffer buffer, DecoderState state, ScanningContext<Symbol> context, BiConsumer<Symbol, Object> matchConsumer) throws DecodeException {
        this.scanMapEntries(buffer, state, context, matchConsumer);
    }

    public void scanAnnotations(InputStream stream, StreamDecoderState state, StreamScanningContext<Symbol> context, BiConsumer<Symbol, Object> matchConsumer) throws DecodeException {
        this.scanMapEntries(stream, state, context, matchConsumer);
    }
}

