/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.stream;

import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.stream.BaseProtocol;
import com.sleepycat.je.rep.stream.FeederFilter;
import com.sleepycat.je.rep.stream.Protocol;
import com.sleepycat.je.rep.utilint.BinaryProtocol;
import com.sleepycat.je.rep.utilint.NamedChannel;
import com.sleepycat.je.utilint.InternalException;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.VLSN;
import java.io.IOException;
import java.util.logging.Logger;

public class SubscriberFeederSyncup {
    private final Logger logger;
    private final RepImpl repImpl;
    private final NamedChannel namedChannel;
    private final Protocol protocol;
    private final FeederFilter filter;

    public SubscriberFeederSyncup(NamedChannel namedChannel, Protocol protocol, FeederFilter filter, RepImpl repImpl, Logger logger) {
        this.namedChannel = namedChannel;
        this.protocol = protocol;
        this.filter = filter;
        this.repImpl = repImpl;
        this.logger = logger;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public VLSN execute(VLSN reqVLSN) throws InternalException {
        VLSN vLSN;
        long startTime = System.currentTimeMillis();
        LoggerUtils.info(this.logger, this.repImpl, "Subscriber-Feeder " + this.namedChannel.getNameIdPair() + " syncup started.");
        try {
            VLSN startVLSN = this.getStartVLSNFromFeeder(reqVLSN);
            if (!startVLSN.equals(VLSN.NULL_VLSN)) {
                LoggerUtils.info(this.logger, this.repImpl, "Response from feeder  " + this.namedChannel.getNameIdPair() + ": the start VLSN " + startVLSN + ", the requested VLSN " + reqVLSN + ", send startStream request with filter.");
                Protocol protocol = this.protocol;
                protocol.getClass();
                this.protocol.write((BinaryProtocol.Message)protocol.new BaseProtocol.StartStream(startVLSN, this.filter), this.namedChannel);
            } else {
                LoggerUtils.info(this.logger, this.repImpl, "Unable to stream from Feeder " + this.namedChannel.getNameIdPair() + " from requested VLSN " + reqVLSN);
            }
            vLSN = startVLSN;
        }
        catch (IllegalStateException e) {
            try {
                throw new InternalException(e.getMessage());
                catch (IOException e2) {
                    throw new InternalException(e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                LoggerUtils.info(this.logger, this.repImpl, String.format("Subscriber to feeder " + this.namedChannel.getNameIdPair() + " sync-up done, elapsed time: %,dms", System.currentTimeMillis() - startTime));
                throw throwable;
            }
        }
        LoggerUtils.info(this.logger, this.repImpl, String.format("Subscriber to feeder " + this.namedChannel.getNameIdPair() + " sync-up done, elapsed time: %,dms", System.currentTimeMillis() - startTime));
        return vLSN;
    }

    private VLSN getStartVLSNFromFeeder(VLSN requestVLSN) throws IOException, IllegalStateException {
        VLSN vlsn;
        LoggerUtils.fine(this.logger, this.repImpl, "Subscriber send requested VLSN " + requestVLSN + " to feeder " + this.namedChannel.getNameIdPair());
        Protocol protocol = this.protocol;
        protocol.getClass();
        this.protocol.write((BinaryProtocol.Message)(BaseProtocol)protocol.new BaseProtocol.EntryRequest(requestVLSN), this.namedChannel);
        BinaryProtocol.Message message = this.protocol.read(this.namedChannel);
        if (message instanceof BaseProtocol.Entry) {
            vlsn = ((BaseProtocol.Entry)message).getWireRecord().getVLSN();
            assert (vlsn.equals(requestVLSN));
            LoggerUtils.finest(this.logger, this.repImpl, "Subscriber successfully requested VLSN " + requestVLSN + " from feeder " + this.namedChannel.getNameIdPair());
        } else if (message instanceof BaseProtocol.AlternateMatchpoint) {
            vlsn = ((BaseProtocol.AlternateMatchpoint)message).getAlternateWireRecord().getVLSN();
            assert (vlsn.compareTo(requestVLSN) < 0);
            LoggerUtils.finest(this.logger, this.repImpl, "Feeder " + this.namedChannel.getNameIdPair() + " returns a valid start VLSN" + vlsn + " but earlier than requested one " + requestVLSN);
        } else if (message instanceof BaseProtocol.EntryNotFound) {
            vlsn = VLSN.NULL_VLSN;
            LoggerUtils.finest(this.logger, this.repImpl, "Feeder " + this.namedChannel.getNameIdPair() + " is unable to service the request vlsn " + requestVLSN);
        } else {
            String msg = "Receive unexpected response " + message.toString() + "from feeder " + this.namedChannel.getNameIdPair();
            LoggerUtils.warning(this.logger, this.repImpl, msg);
            throw new IllegalStateException(msg);
        }
        return vlsn;
    }
}

