/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.impl.node;

import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.RepParams;
import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.rep.impl.node.Replica;
import com.sleepycat.je.rep.net.DataChannel;
import com.sleepycat.je.rep.stream.BaseProtocol;
import com.sleepycat.je.rep.stream.Protocol;
import com.sleepycat.je.rep.utilint.BinaryProtocol;
import com.sleepycat.je.rep.utilint.RepUtils;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.StoppableThread;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.TestHookExecute;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public abstract class ReplicaOutputThreadBase
extends StoppableThread {
    private int queueSize;
    private int heartbeatMs;
    private volatile Exception exception;
    private RepImpl repImpl;
    private BlockingQueue<Long> outputQueue;
    protected Protocol protocol;
    protected DataChannel replicaFeederChannel;
    public static final Long EOF = Long.MAX_VALUE;
    public static final Long HEARTBEAT_ACK = EOF - 1L;
    public static final Long SHUTDOWN_ACK = EOF - 2L;
    private TestHook<Object> outputHook;
    static final int maxGroupedAcks = 170;
    final ArrayList<Long> groupAcks = new ArrayList(170);
    boolean groupAcksEnabled;
    private volatile long numGroupedAcks = 0L;
    private Logger logger;

    ReplicaOutputThreadBase(RepImpl repImpl) {
        super(repImpl, "ReplicaOutputThread");
        this.logger = repImpl.getLogger();
        this.repImpl = repImpl;
        RepNode repNode = repImpl.getRepNode();
        Replica replica = repNode.getReplica();
        this.outputQueue = repImpl.getReplay().getOutputQueue();
        this.protocol = replica.getProtocol();
        this.replicaFeederChannel = replica.getReplicaFeederChannel();
        this.heartbeatMs = repImpl.getConfigManager().getInt(RepParams.HEARTBEAT_INTERVAL);
        this.queueSize = this.outputQueue.remainingCapacity();
        this.groupAcksEnabled = this.protocol.getVersion() > 5 && repImpl.getConfigManager().getBoolean(RepParams.ENABLE_GROUP_ACKS);
    }

    public ReplicaOutputThreadBase(RepImpl repImpl, RepNode repNode, BlockingQueue<Long> outputQueue, Protocol protocol, DataChannel replicaFeederChannel) {
        super(repImpl, "ReplicaOutputThread");
        this.initialize(repImpl, repNode, outputQueue, protocol, replicaFeederChannel);
    }

    private void initialize(RepImpl repImpl, RepNode repNode, BlockingQueue<Long> outputQueue, Protocol protocol, DataChannel replicaFeederChannel) {
        this.logger = repImpl.getLogger();
        this.repImpl = repImpl;
        this.outputQueue = outputQueue;
        this.protocol = protocol;
        this.replicaFeederChannel = replicaFeederChannel;
        this.heartbeatMs = repImpl.getConfigManager().getInt(RepParams.HEARTBEAT_INTERVAL);
        this.queueSize = outputQueue.remainingCapacity();
        this.groupAcksEnabled = protocol.getVersion() > 5 && repImpl.getConfigManager().getBoolean(RepParams.ENABLE_GROUP_ACKS);
    }

    @Override
    protected Logger getLogger() {
        return this.logger;
    }

    public Exception getException() {
        return this.exception;
    }

    public long getNumGroupedAcks() {
        return this.numGroupedAcks;
    }

    public long getOutputQueueSize() {
        return this.outputQueue.size();
    }

    public void setOutputHook(TestHook<Object> outputHook) {
        this.outputHook = outputHook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long maxPending = 0L;
        long numAcks = 0L;
        LoggerUtils.info(this.logger, this.repImpl, "Replica output thread started. Queue size:" + this.queueSize + " Max grouped acks:" + 170);
        try {
            Long txnId = this.outputQueue.poll(this.heartbeatMs, TimeUnit.MILLISECONDS);
            while (!EOF.equals(txnId)) {
                assert (TestHookExecute.doHookIfSet(this.outputHook, this));
                if (txnId == null || HEARTBEAT_ACK.equals(txnId)) {
                    this.writeHeartbeat(txnId);
                } else if (SHUTDOWN_ACK.equals(txnId)) {
                    this.protocol.write((BinaryProtocol.Message)new BaseProtocol.ShutdownResponse(this.protocol), this.replicaFeederChannel);
                } else {
                    int pending = this.outputQueue.size();
                    if ((long)pending > maxPending && (maxPending = (long)pending) % 100L == 0L) {
                        LoggerUtils.info(this.logger, this.repImpl, "Max pending acks:" + maxPending);
                    }
                    if (pending == 0 || !this.groupAcksEnabled) {
                        ++numAcks;
                        Protocol protocol = this.protocol;
                        protocol.getClass();
                        this.protocol.write((BinaryProtocol.Message)new BaseProtocol.Ack((BaseProtocol)protocol, txnId), this.replicaFeederChannel);
                    } else if (this.groupWriteAcks(txnId)) {
                        break;
                    }
                }
                txnId = this.outputQueue.poll(this.heartbeatMs, TimeUnit.MILLISECONDS);
            }
        }
        catch (Exception e) {
            this.exception = e;
            RepUtils.shutdownChannel(this.replicaFeederChannel);
            LoggerUtils.info(this.logger, this.repImpl, this + "exiting with exception:" + e);
        }
        finally {
            LoggerUtils.info(this.logger, this.repImpl, this + "exited. " + "Singleton acks sent:" + numAcks + " Grouped acks sent:" + this.numGroupedAcks + " Max pending acks:" + maxPending);
        }
    }

    public abstract void writeHeartbeat(Long var1) throws IOException;

    private boolean groupWriteAcks(long txnId) throws IOException {
        boolean eof = false;
        this.groupAcks.clear();
        this.groupAcks.add(txnId);
        this.outputQueue.drainTo(this.groupAcks, 169);
        long[] txnIds = new long[this.groupAcks.size()];
        int i = 0;
        for (long gtxnId : this.groupAcks) {
            if (gtxnId == EOF) {
                eof = true;
                break;
            }
            if (gtxnId == SHUTDOWN_ACK) {
                this.protocol.write((BinaryProtocol.Message)new BaseProtocol.ShutdownResponse(this.protocol), this.replicaFeederChannel);
                eof = true;
                break;
            }
            if (gtxnId == HEARTBEAT_ACK) {
                this.writeHeartbeat(gtxnId);
                continue;
            }
            txnIds[i++] = gtxnId;
        }
        if (i > 0) {
            if (txnIds.length > i) {
                long[] la = new long[txnIds.length - 1];
                System.arraycopy(txnIds, 0, la, 0, la.length);
                txnIds = la;
            }
            Protocol protocol = this.protocol;
            protocol.getClass();
            this.protocol.write((BinaryProtocol.Message)new BaseProtocol.GroupAck((BaseProtocol)protocol, txnIds), this.replicaFeederChannel);
            this.numGroupedAcks += (long)txnIds.length;
        }
        return eof;
    }

    @Override
    protected int initiateSoftShutdown() {
        if (!this.outputQueue.offer(EOF)) {
            return -1;
        }
        return 10000;
    }
}

